/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import java.lang.reflect.Modifier;
import org.datacleaner.api.Renderable;
import org.datacleaner.api.Renderer;
import org.datacleaner.api.RendererBean;
import org.datacleaner.api.RenderingFormat;
import org.datacleaner.descriptors.DescriptorException;
import org.datacleaner.descriptors.RendererBeanDescriptor;
import org.datacleaner.descriptors.SimpleComponentDescriptor;
import org.datacleaner.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AnnotationBasedRendererBeanDescriptor<R extends Renderer<?, ?>>
extends SimpleComponentDescriptor<R>
implements RendererBeanDescriptor<R> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AnnotationBasedRendererBeanDescriptor.class);
    private final Class<? extends RenderingFormat<?>> _renderingFormat;
    private final Class<?> _formatOutputType;
    private final Class<? extends Renderable> _rendererInputType;
    private final Class<?> _rendererOutputType;

    protected AnnotationBasedRendererBeanDescriptor(Class<R> rendererClass) throws DescriptorException {
        super(rendererClass, true);
        RendererBean rendererBeanAnnotation = ReflectionUtils.getAnnotation(rendererClass, RendererBean.class);
        if (rendererBeanAnnotation == null) {
            throw new DescriptorException(rendererClass + " doesn't implement the RendererBean annotation");
        }
        this._renderingFormat = rendererBeanAnnotation.value();
        if (this._renderingFormat == null || this._renderingFormat.isInterface() || Modifier.isAbstract(this._renderingFormat.getModifiers())) {
            throw new DescriptorException("Rendering format (" + this._renderingFormat + ") is not a non-abstract class");
        }
        this._formatOutputType = ReflectionUtils.getTypeParameter(this._renderingFormat, RenderingFormat.class, 0);
        logger.debug("Found format output type: {}", this._formatOutputType);
        if (this._formatOutputType == null) {
            throw new DescriptorException("Could not determine output type of rendering format: " + this._renderingFormat);
        }
        Class<?> rendererInputType = ReflectionUtils.getTypeParameter(rendererClass, Renderer.class, 0);
        this._rendererInputType = rendererInputType;
        logger.debug("Found renderer input type: {}", this._rendererInputType);
        this._rendererOutputType = ReflectionUtils.getTypeParameter(rendererClass, Renderer.class, 1);
        logger.debug("Found renderer output type: {}", this._rendererOutputType);
        if (this._rendererOutputType == null) {
            throw new DescriptorException("Could not determine output type of renderer: " + rendererClass);
        }
        if (!ReflectionUtils.is(this._rendererOutputType, this._formatOutputType)) {
            throw new DescriptorException("The renderer output type (" + this._rendererOutputType + ") is not a valid instance or sub-class of format output type (" + this._formatOutputType + ")");
        }
    }

    public Class<? extends RenderingFormat<?>> getRenderingFormat() {
        return this._renderingFormat;
    }

    public boolean isOutputApplicableFor(Class<?> requiredClass) {
        if (!ReflectionUtils.is(requiredClass, this._formatOutputType)) {
            logger.debug("{} is not applicable to the format output type: {}", requiredClass, this._formatOutputType);
            return false;
        }
        boolean result = ReflectionUtils.is(this._rendererOutputType, requiredClass);
        if (!result) {
            logger.debug("{} is not applicable to the renderer output type: {}", requiredClass, this._rendererOutputType);
        }
        return result;
    }

    public Class<? extends Renderable> getRenderableType() {
        return this._rendererInputType;
    }
}

