/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.Filter;
import org.datacleaner.api.Renderer;
import org.datacleaner.api.Transformer;
import org.datacleaner.descriptors.AnalyzerDescriptor;
import org.datacleaner.descriptors.AnnotationBasedAnalyzerComponentDescriptor;
import org.datacleaner.descriptors.AnnotationBasedFilterComponentDescriptor;
import org.datacleaner.descriptors.AnnotationBasedRendererBeanDescriptor;
import org.datacleaner.descriptors.AnnotationBasedTransformerComponentDescriptor;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.descriptors.RendererBeanDescriptor;
import org.datacleaner.descriptors.ResultDescriptor;
import org.datacleaner.descriptors.ResultDescriptorImpl;
import org.datacleaner.descriptors.SimpleComponentDescriptor;
import org.datacleaner.descriptors.TransformerDescriptor;

public class Descriptors {
    private static final ConcurrentMap<Class<?>, ResultDescriptor> _resultDescriptors = new ConcurrentHashMap();

    private Descriptors() {
    }

    public static <C> ComponentDescriptor<C> ofComponent(Class<C> componentClass) {
        return new SimpleComponentDescriptor<C>(componentClass, true);
    }

    public static <A extends Analyzer<?>> AnalyzerDescriptor<A> ofAnalyzer(Class<A> analyzerClass) {
        return new AnnotationBasedAnalyzerComponentDescriptor<A>(analyzerClass);
    }

    public static <F extends Filter<C>, C extends Enum<C>> FilterDescriptor<F, C> ofFilter(Class<F> filterClass) {
        return new AnnotationBasedFilterComponentDescriptor(filterClass);
    }

    public static FilterDescriptor<?, ?> ofFilterUnbound(Class<?> clazz) {
        return new AnnotationBasedFilterComponentDescriptor(clazz);
    }

    public static <T extends Transformer> TransformerDescriptor<T> ofTransformer(Class<T> transformerClass) {
        return new AnnotationBasedTransformerComponentDescriptor<T>(transformerClass);
    }

    public static <R extends Renderer<?, ?>> RendererBeanDescriptor<R> ofRenderer(Class<R> rendererClass) {
        return new AnnotationBasedRendererBeanDescriptor<R>(rendererClass);
    }

    public static ResultDescriptor ofResult(AnalyzerResult result) {
        if (result == null) {
            throw new IllegalArgumentException("AnalyzerResult cannot be null");
        }
        return Descriptors.ofResult(result.getClass());
    }

    public static ResultDescriptor ofResult(Class<? extends AnalyzerResult> resultClass) {
        ResultDescriptor resultDescriptor = (ResultDescriptor)_resultDescriptors.get(resultClass);
        if (resultDescriptor == null) {
            resultDescriptor = new ResultDescriptorImpl(resultClass);
            _resultDescriptors.put(resultClass, resultDescriptor);
        }
        return resultDescriptor;
    }
}

