/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.AnalyzerResultReducer;
import org.datacleaner.api.Distributed;
import org.datacleaner.api.Metric;
import org.datacleaner.api.NoAnalyzerResultReducer;
import org.datacleaner.descriptors.MetricDescriptor;
import org.datacleaner.descriptors.MetricDescriptorImpl;
import org.datacleaner.descriptors.ResultDescriptor;
import org.datacleaner.util.ReflectionUtils;

final class ResultDescriptorImpl
implements ResultDescriptor {
    private static final long serialVersionUID = 1L;
    private final Class<? extends AnalyzerResult> _resultClass;
    private final Set<MetricDescriptor> _metrics;

    public ResultDescriptorImpl(Class<? extends AnalyzerResult> resultClass) {
        this._resultClass = resultClass;
        Method[] metricMethods = ReflectionUtils.getMethods(resultClass, Metric.class);
        this._metrics = new TreeSet<MetricDescriptor>();
        for (Method method : metricMethods) {
            MetricDescriptorImpl metric = new MetricDescriptorImpl(resultClass, method);
            this._metrics.add(metric);
        }
    }

    public Class<? extends AnalyzerResult> getResultClass() {
        return this._resultClass;
    }

    public MetricDescriptor getResultMetric(String name) {
        if (name == null) {
            return null;
        }
        for (MetricDescriptor metric : this._metrics) {
            if (!name.equals(metric.getName())) continue;
            return metric;
        }
        for (MetricDescriptor metric : this._metrics) {
            if (!name.equalsIgnoreCase(metric.getName())) continue;
            return metric;
        }
        return null;
    }

    public Set<MetricDescriptor> getResultMetrics() {
        if (this._metrics == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this._metrics);
    }

    public Class<? extends AnalyzerResultReducer<?>> getResultReducerClass() {
        Distributed distributedResult = ReflectionUtils.getAnnotation(this.getResultClass(), Distributed.class);
        if (distributedResult != null) {
            if (!distributedResult.value()) {
                return null;
            }
            Class reducer = distributedResult.reducer();
            if (reducer != null && reducer != NoAnalyzerResultReducer.class) {
                return reducer;
            }
        }
        return null;
    }
}

