/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.ArrayUtils;
import org.datacleaner.api.Alias;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Close;
import org.datacleaner.api.ComponentCategory;
import org.datacleaner.api.ComponentSuperCategory;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.Distributed;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.Provided;
import org.datacleaner.api.Validate;
import org.datacleaner.descriptors.AbstractDescriptor;
import org.datacleaner.descriptors.CloseMethodDescriptor;
import org.datacleaner.descriptors.CloseMethodDescriptorImpl;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptorImpl;
import org.datacleaner.descriptors.DescriptorException;
import org.datacleaner.descriptors.InitializeMethodDescriptor;
import org.datacleaner.descriptors.InitializeMethodDescriptorImpl;
import org.datacleaner.descriptors.ProvidedPropertyDescriptor;
import org.datacleaner.descriptors.ProvidedPropertyDescriptorImpl;
import org.datacleaner.descriptors.ValidateMethodDescriptor;
import org.datacleaner.descriptors.ValidateMethodDescriptorImpl;
import org.datacleaner.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleComponentDescriptor<B>
extends AbstractDescriptor<B>
implements ComponentDescriptor<B> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SimpleComponentDescriptor.class);
    protected final Set<ConfiguredPropertyDescriptor> _configuredProperties = new TreeSet<ConfiguredPropertyDescriptor>();
    protected final Set<ProvidedPropertyDescriptor> _providedProperties = new TreeSet<ProvidedPropertyDescriptor>();
    protected final Set<InitializeMethodDescriptor> _initializeMethods;
    protected final Set<ValidateMethodDescriptor> _validateMethods = new HashSet<ValidateMethodDescriptor>();
    protected final Set<CloseMethodDescriptor> _closeMethods;

    public SimpleComponentDescriptor(Class<B> beanClass) {
        this(beanClass, false);
    }

    public SimpleComponentDescriptor(Class<B> beanClass, boolean initialize) {
        super(beanClass);
        this._initializeMethods = new HashSet<InitializeMethodDescriptor>();
        this._closeMethods = new HashSet<CloseMethodDescriptor>();
        if (initialize) {
            this.visitClass();
        }
    }

    public String getDisplayName() {
        Named named = this.getAnnotation(Named.class);
        if (named == null) {
            return this.getComponentClass().getSimpleName();
        }
        return named.value();
    }

    public final String getDescription() {
        Description description = this.getAnnotation(Description.class);
        if (description == null) {
            return null;
        }
        return description.value();
    }

    public final <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return ReflectionUtils.getAnnotation(this.getComponentClass(), annotationClass);
    }

    public final Set<Annotation> getAnnotations() {
        Annotation[] annotations = this.getComponentClass().getAnnotations();
        return new HashSet<Annotation>(Arrays.asList(annotations));
    }

    public final Set<ComponentCategory> getComponentCategories() {
        Categorized categorized = this.getAnnotation(Categorized.class);
        if (categorized == null) {
            return Collections.emptySet();
        }
        Class[] value = categorized.value();
        if (value == null || value.length == 0) {
            return Collections.emptySet();
        }
        HashSet<ComponentCategory> result = new HashSet<ComponentCategory>();
        for (Class categoryClass : value) {
            if (categoryClass == ComponentCategory.class) continue;
            ComponentCategory category = (ComponentCategory)ReflectionUtils.newInstance(categoryClass);
            result.add(category);
        }
        return result;
    }

    public ComponentSuperCategory getComponentSuperCategory() {
        Class<ComponentSuperCategory> superCategoryClass;
        Categorized categorized = this.getAnnotation(Categorized.class);
        if (categorized == null) {
            superCategoryClass = this.getDefaultComponentSuperCategoryClass();
        } else {
            superCategoryClass = categorized.superCategory();
            if (superCategoryClass == ComponentSuperCategory.class) {
                superCategoryClass = this.getDefaultComponentSuperCategoryClass();
            }
        }
        ComponentSuperCategory superCategory = (ComponentSuperCategory)ReflectionUtils.newInstance(superCategoryClass);
        return superCategory;
    }

    protected Class<? extends ComponentSuperCategory> getDefaultComponentSuperCategoryClass() {
        return ComponentSuperCategory.class;
    }

    public B newInstance() {
        try {
            return this.getComponentClass().newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not construct new instance of " + this.getComponentClass(), e);
        }
    }

    @Override
    protected void visitClass() {
        block3: {
            super.visitClass();
            if (ReflectionUtils.isCloseable(this.getComponentClass())) {
                try {
                    Method method = this.getComponentClass().getMethod("close", new Class[0]);
                    CloseMethodDescriptorImpl cmd = new CloseMethodDescriptorImpl(method, this);
                    this._closeMethods.add(cmd);
                }
                catch (Exception e) {
                    logger.error("Unexpected exception while getting close() method from Closeable", (Throwable)e);
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    protected void visitField(Field field) {
        boolean isInject = ReflectionUtils.isAnnotationPresent(field, Inject.class);
        boolean isConfigured = ReflectionUtils.isAnnotationPresent(field, Configured.class);
        boolean isProvided = ReflectionUtils.isAnnotationPresent(field, Provided.class);
        if (isConfigured && isProvided) {
            throw new DescriptorException("The field " + field + " is annotated with both @Configured and @Provided, which are mutually exclusive.");
        }
        if (!isConfigured && (isInject || isProvided)) {
            this._providedProperties.add(new ProvidedPropertyDescriptorImpl(field, this));
        } else if (isConfigured) {
            if (!isInject) {
                logger.debug("No @Inject annotation found for @Configured field: {}", (Object)field);
            }
            ConfiguredPropertyDescriptorImpl cpd = new ConfiguredPropertyDescriptorImpl(field, this);
            this._configuredProperties.add(cpd);
        }
    }

    @Override
    protected void visitMethod(Method method) {
        boolean isInitializeAnnotationPresent = ReflectionUtils.isAnnotationPresent(method, Initialize.class);
        boolean isPostConstructAnnotationPresent = ReflectionUtils.isAnnotationPresent(method, PostConstruct.class);
        boolean isInitialize = isInitializeAnnotationPresent || isPostConstructAnnotationPresent;
        boolean isPreDestroyAnnotationPresent = ReflectionUtils.isAnnotationPresent(method, PreDestroy.class);
        boolean isCloseAnnotationPresent = ReflectionUtils.isAnnotationPresent(method, Close.class);
        boolean isClose = isCloseAnnotationPresent || isPreDestroyAnnotationPresent;
        boolean isValidate = ReflectionUtils.isAnnotationPresent(method, Validate.class);
        if (isInitialize) {
            this._initializeMethods.add(new InitializeMethodDescriptorImpl(method, this));
        }
        if (isValidate) {
            this._validateMethods.add(new ValidateMethodDescriptorImpl(method, this));
        }
        if (isClose) {
            this._closeMethods.add(new CloseMethodDescriptorImpl(method, this));
        }
    }

    public final Set<InitializeMethodDescriptor> getInitializeMethods() {
        return Collections.unmodifiableSet(this._initializeMethods);
    }

    public final Set<ConfiguredPropertyDescriptor> getConfiguredProperties() {
        return Collections.unmodifiableSet(this._configuredProperties);
    }

    public final Set<CloseMethodDescriptor> getCloseMethods() {
        return Collections.unmodifiableSet(this._closeMethods);
    }

    public final Set<ValidateMethodDescriptor> getValidateMethods() {
        return Collections.unmodifiableSet(this._validateMethods);
    }

    public final Set<ProvidedPropertyDescriptor> getProvidedProperties() {
        return Collections.unmodifiableSet(this._providedProperties);
    }

    public final Set<ProvidedPropertyDescriptor> getProvidedPropertiesByType(Class<?> cls) {
        HashSet<ProvidedPropertyDescriptor> result = new HashSet<ProvidedPropertyDescriptor>();
        for (ProvidedPropertyDescriptor descriptor : this._providedProperties) {
            if (!ReflectionUtils.is(descriptor.getType(), cls)) continue;
            result.add(descriptor);
        }
        return result;
    }

    public final ConfiguredPropertyDescriptor getConfiguredProperty(String configuredName) {
        for (ConfiguredPropertyDescriptor configuredDescriptor : this._configuredProperties) {
            if (!configuredName.equals(configuredDescriptor.getName())) continue;
            return configuredDescriptor;
        }
        for (ConfiguredPropertyDescriptor configuredDescriptor : this._configuredProperties) {
            Object[] aliases = configuredDescriptor.getAliases();
            if (!ArrayUtils.contains((Object[])aliases, (Object)configuredName)) continue;
            return configuredDescriptor;
        }
        return null;
    }

    public final Set<ConfiguredPropertyDescriptor> getConfiguredPropertiesByAnnotation(Class<? extends Annotation> annotationClass) {
        TreeSet<ConfiguredPropertyDescriptor> set = new TreeSet<ConfiguredPropertyDescriptor>();
        for (ConfiguredPropertyDescriptor configuredDescriptor : this._configuredProperties) {
            Annotation annotation = configuredDescriptor.getAnnotation(annotationClass);
            if (annotation == null) continue;
            set.add(configuredDescriptor);
        }
        return set;
    }

    public final Set<ConfiguredPropertyDescriptor> getConfiguredPropertiesByType(Class<?> type, boolean includeArrays) {
        TreeSet<ConfiguredPropertyDescriptor> set = new TreeSet<ConfiguredPropertyDescriptor>();
        for (ConfiguredPropertyDescriptor configuredDescriptor : this._configuredProperties) {
            Class baseType;
            boolean include = includeArrays ? ReflectionUtils.is(configuredDescriptor.getBaseType(), type) : ((baseType = configuredDescriptor.getType()).isArray() == type.isArray() ? ReflectionUtils.is(baseType, type) : false);
            if (!include) continue;
            set.add(configuredDescriptor);
        }
        return set;
    }

    public int compareTo(ComponentDescriptor<?> o) {
        if (o == null) {
            return 1;
        }
        Class otherComponentClass = o.getComponentClass();
        if (otherComponentClass == null) {
            return 1;
        }
        int diff = this.getDisplayName().compareTo(o.getDisplayName());
        if (diff == 0) {
            String thisBeanClassName = this.getComponentClass().toString();
            String thatBeanClassName = otherComponentClass.toString();
            diff = thisBeanClassName.compareTo(thatBeanClassName);
        }
        return diff;
    }

    public boolean isDistributable() {
        Distributed distributed = this.getAnnotation(Distributed.class);
        if (distributed == null) {
            return false;
        }
        return distributed.value();
    }

    public final String[] getAliases() {
        Alias alias = this.getAnnotation(Alias.class);
        if (alias == null) {
            return new String[0];
        }
        return alias.value();
    }

    public final Set<ConfiguredPropertyDescriptor> getConfiguredPropertiesForInput() {
        return this.getConfiguredPropertiesForInput(true);
    }

    public final Set<ConfiguredPropertyDescriptor> getConfiguredPropertiesForInput(boolean includeOptional) {
        TreeSet<ConfiguredPropertyDescriptor> descriptors = new TreeSet<ConfiguredPropertyDescriptor>(this._configuredProperties);
        Iterator it = descriptors.iterator();
        while (it.hasNext()) {
            ConfiguredPropertyDescriptor propertyDescriptor = (ConfiguredPropertyDescriptor)it.next();
            if (!propertyDescriptor.isInputColumn()) {
                it.remove();
                continue;
            }
            if (includeOptional || propertyDescriptor.isRequired()) continue;
            it.remove();
        }
        return descriptors;
    }
}

