/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.extensions;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

public class CompoundClassLoader
extends ClassLoader {
    private Collection<ClassLoader> loaders;

    public CompoundClassLoader(Collection<ClassLoader> loaders) {
        this.loaders = new ArrayList<ClassLoader>(loaders);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> class1 = null;
        if (class1 == null) {
            class1 = this.locateClass(name);
        }
        if (class1 == null) {
            throw new ClassNotFoundException("Could not resolve class: " + name);
        }
        return class1;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        for (ClassLoader cl : this.loaders) {
            if (url != null) break;
            url = cl.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(final String name) throws IOException {
        return new Enumeration<URL>(){
            private final URL resource;
            private boolean checked;
            {
                this.resource = CompoundClassLoader.this.getResource(name);
                this.checked = false;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.resource == null) {
                    return false;
                }
                if (!this.checked) {
                    this.checked = true;
                    return true;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                return this.resource;
            }
        };
    }

    private Class<?> locateClass(String name) {
        Class<?> result = null;
        for (ClassLoader cl : this.loaders) {
            if (result != null) break;
            try {
                result = cl.loadClass(name);
            }
            catch (ClassNotFoundException e) {}
        }
        return result;
    }
}

