/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.extensions;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ExtensionClassLoader
extends ClassLoader {
    private static final char FORWARDSLASH = '/';
    private ClassLoader globalParent;
    private String name;

    public ExtensionClassLoader(ClassLoader parent, ClassLoader globalParent) {
        this(parent, globalParent, "");
    }

    public ExtensionClassLoader(ClassLoader parent, ClassLoader globalParent, String name) {
        super(parent);
        this.globalParent = globalParent;
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> class1 = null;
        if (this.globalParent != null) {
            try {
                class1 = this.globalParent.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (class1 == null) {
            class1 = this.findLoadedClass(name);
        }
        if (class1 == null && (class1 = this.getClass(name)) != null && resolve) {
            this.resolveClass(class1);
        }
        return class1;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.globalParent != null) {
            url = this.globalParent.getResource(name);
        }
        if (url == null && this.getParent() != null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    public String toString() {
        return "Extension classloader for: " + this.name;
    }

    private Class<?> getClass(String name) throws ClassNotFoundException {
        String file = name.replace('.', '/') + ".class";
        byte[] b = null;
        try {
            b = this.loadClassData(file);
            if (b == null) {
                return null;
            }
            this.definePackageForClass(name);
            Class<?> c = this.defineClass(name, b, 0, b.length);
            return c;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void definePackageForClass(String name) {
        String pkgname;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgname = name.substring(0, i))) == null) {
            this.definePackage(pkgname, null, null, null, null, null, null, null);
        }
    }

    private byte[] loadClassData(String name) throws IOException {
        InputStream stream = this.getResourceAsStream(name);
        if (stream == null) {
            return null;
        }
        int size = stream.available();
        byte[] buff = new byte[size];
        DataInputStream in = new DataInputStream(stream);
        in.readFully(buff);
        in.close();
        return buff;
    }
}

