/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.extensions;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.metamodel.util.HasName;
import org.datacleaner.descriptors.ClasspathScanDescriptorProvider;
import org.datacleaner.descriptors.DescriptorProvider;
import org.datacleaner.extensions.ClassLoaderUtils;
import org.datacleaner.extensions.CompoundClassLoader;
import org.datacleaner.extensions.ExtensionClassLoader;
import org.datacleaner.util.FileFilters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionPackage
implements Serializable,
HasName {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ExtensionPackage.class);
    private static Collection<ClassLoader> _allExtensionClassLoaders = new ArrayList<ClassLoader>();
    private transient boolean _loaded = false;
    private transient int _loadedAnalyzers;
    private transient int _loadedTransformers;
    private transient int _loadedFilters;
    private transient int _loadedRenderers;
    private transient ClassLoader _classLoader;
    private final File[] _files;
    private final String _name;
    private final String _scanPackage;
    private final boolean _scanRecursive;
    private final Map<String, String> _additionalProperties;

    public ExtensionPackage(String name, String scanPackage, boolean scanRecursive, File[] files) {
        this._name = name;
        if (scanPackage == null) {
            scanPackage = "";
        }
        this._scanPackage = scanPackage;
        this._scanRecursive = scanRecursive;
        this._files = files;
        this._additionalProperties = new HashMap<String, String>();
    }

    public File[] getFiles() {
        return Arrays.copyOf(this._files, this._files.length);
    }

    public boolean isExternal() {
        return this._files != null && this._files.length > 0;
    }

    private boolean isInternal() {
        return !this.isExternal();
    }

    public String getName() {
        return this._name;
    }

    public String getScanPackage() {
        return this._scanPackage;
    }

    public boolean isScanRecursive() {
        return this._scanRecursive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadExtension() {
        if (this.isInternal()) {
            this._classLoader = ClassLoaderUtils.getParentClassLoader();
            return;
        }
        Class<ExtensionPackage> clazz = ExtensionPackage.class;
        synchronized (ExtensionPackage.class) {
            ClassLoader jarFileClassLoader = ClassLoaderUtils.createClassLoader(this.getJarFiles(), null);
            _allExtensionClassLoaders.add(jarFileClassLoader);
            ExtensionClassLoader extensionLoader = new ExtensionClassLoader(jarFileClassLoader, ClassLoaderUtils.getParentClassLoader(), "Extension: " + this.getName());
            this._classLoader = extensionLoader;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private File[] getJarFiles() {
        if (this._files.length == 1 && this._files[0].isDirectory()) {
            return this._files[0].listFiles(FileFilters.JAR);
        }
        return this._files;
    }

    public ExtensionPackage loadDescriptors(DescriptorProvider descriptorProvider) throws IllegalStateException {
        if (!this._loaded) {
            if (!(descriptorProvider instanceof ClasspathScanDescriptorProvider)) {
                throw new IllegalStateException("Can only load user extensions when descriptor provider is of classpath scanner type.");
            }
            ClasspathScanDescriptorProvider classpathScanner = (ClasspathScanDescriptorProvider)descriptorProvider;
            int analyzersBefore = classpathScanner.getAnalyzerDescriptors().size();
            int transformersBefore = classpathScanner.getTransformerDescriptors().size();
            int filtersBefore = classpathScanner.getFilterDescriptors().size();
            int renderersBefore = classpathScanner.getRendererBeanDescriptors().size();
            if (this._classLoader == null) {
                this.loadExtension();
            }
            if (this._scanPackage != null) {
                classpathScanner.scanPackage(this._scanPackage, this._scanRecursive, this._classLoader, true, this.getJarFiles());
            }
            this._loadedAnalyzers = classpathScanner.getAnalyzerDescriptors().size() - analyzersBefore;
            this._loadedTransformers = classpathScanner.getTransformerDescriptors().size() - transformersBefore;
            this._loadedFilters = classpathScanner.getFilterDescriptors().size() - filtersBefore;
            this._loadedRenderers = classpathScanner.getRendererBeanDescriptors().size() - renderersBefore;
            this._loaded = true;
            logger.info("Succesfully loaded extension '{}' containing {} analyzers, {} transformers, {} filters, {} renderers", new Object[]{this.getName(), this.getLoadedAnalyzers(), this.getLoadedTransformers(), this.getLoadedFilters(), this.getLoadedRenderers()});
        }
        return this;
    }

    public Map<String, String> getAdditionalProperties() {
        return this._additionalProperties;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public int getLoadedRenderers() {
        return this._loadedRenderers;
    }

    public int getLoadedAnalyzers() {
        return this._loadedAnalyzers;
    }

    public int getLoadedFilters() {
        return this._loadedFilters;
    }

    public int getLoadedTransformers() {
        return this._loadedTransformers;
    }

    public static ClassLoader getExtensionClassLoader() {
        ArrayList<ClassLoader> childClassLoaders = new ArrayList<ClassLoader>();
        childClassLoaders.addAll(_allExtensionClassLoaders);
        childClassLoaders.add(ClassLoaderUtils.getParentClassLoader());
        return new CompoundClassLoader(childClassLoaders);
    }

    public String getDescription() {
        return this._additionalProperties.get("description");
    }

    public String getVersion() {
        return this._additionalProperties.get("version");
    }

    public String getUrl() {
        return this._additionalProperties.get("url");
    }

    public String getAuthor() {
        return this._additionalProperties.get("author");
    }

    public String toString() {
        return this.getName();
    }
}

