/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.CompoundComponentRequirement;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.ImmutableFilterOutcome;
import org.datacleaner.job.SimpleComponentRequirement;
import org.datacleaner.job.builder.LazyFilterOutcome;

public final class AnalysisJobImmutabilizer {
    private final HashMap<LazyFilterOutcome, ImmutableFilterOutcome> _referenceMap = new HashMap();

    public FilterOutcome load(FilterOutcome outcome) {
        if (outcome instanceof LazyFilterOutcome) {
            LazyFilterOutcome lfo = (LazyFilterOutcome)outcome;
            ImmutableFilterOutcome result = this._referenceMap.get((Object)lfo);
            if (result == null) {
                result = new ImmutableFilterOutcome(lfo.getFilterJob(), lfo.getCategory());
                this._referenceMap.put(lfo, result);
            }
            return result;
        }
        return outcome;
    }

    public ComponentRequirement load(ComponentRequirement req) {
        if (req instanceof SimpleComponentRequirement) {
            FilterOutcome originalOutcome = ((SimpleComponentRequirement)req).getOutcome();
            FilterOutcome loadedOutcome = this.load(originalOutcome);
            if (loadedOutcome != originalOutcome) {
                return new SimpleComponentRequirement(loadedOutcome);
            }
        } else if (req instanceof CompoundComponentRequirement) {
            boolean changed = false;
            Set<FilterOutcome> originalOutcomes = ((CompoundComponentRequirement)req).getOutcomes();
            ArrayList<FilterOutcome> loadedOutcomes = new ArrayList<FilterOutcome>(originalOutcomes.size());
            for (FilterOutcome originalOutcome : originalOutcomes) {
                FilterOutcome loadedOutcome = this.load(originalOutcome);
                if (loadedOutcome != originalOutcome) {
                    changed = true;
                }
                loadedOutcomes.add(loadedOutcome);
            }
            if (changed) {
                return new CompoundComponentRequirement(loadedOutcomes);
            }
        }
        return req;
    }
}

