/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.datacleaner.api.InputRow;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.FilterOutcomes;

public class CompoundComponentRequirement
implements ComponentRequirement {
    private static final long serialVersionUID = 1L;
    private final Set<FilterOutcome> _outcomes = new LinkedHashSet<FilterOutcome>();

    public CompoundComponentRequirement(Collection<? extends FilterOutcome> outcomes) {
        for (FilterOutcome filterOutcome : outcomes) {
            this._outcomes.add(filterOutcome);
        }
    }

    public CompoundComponentRequirement(FilterOutcome ... outcomes) {
        for (FilterOutcome outcome : outcomes) {
            this._outcomes.add(outcome);
        }
    }

    public Set<FilterOutcome> getOutcomes() {
        return this._outcomes;
    }

    public Collection<FilterOutcome> getProcessingDependencies() {
        return this.getOutcomes();
    }

    public boolean isSatisfied(InputRow row, FilterOutcomes outcomes) {
        for (FilterOutcome outcome : outcomes.getOutcomes()) {
            if (!this._outcomes.contains(outcome)) continue;
            return true;
        }
        return false;
    }

    public String getSimpleName() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (FilterOutcome outcome : this._outcomes) {
            if (sb.length() != 0) {
                sb.append(" OR ");
            }
            sb.append(outcome.toString());
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._outcomes == null ? 0 : this._outcomes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundComponentRequirement other = (CompoundComponentRequirement)obj;
        return !(this._outcomes == null ? other._outcomes != null : !this._outcomes.equals(other._outcomes));
    }
}

