/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.BaseObject;
import org.datacleaner.job.AnalysisJobMetadata;

public class ImmutableAnalysisJobMetadata
extends BaseObject
implements AnalysisJobMetadata {
    private final String _jobName;
    private final String _jobVersion;
    private final String _jobDescription;
    private final String _author;
    private final Date _createdDate;
    private final Date _updatedDate;
    private final String _datastoreName;
    private final List<String> _sourceColumnPaths;
    private final Map<String, String> _variables;
    private final List<ColumnType> _sourceColumnTypes;
    private final Map<String, String> _properties;

    public ImmutableAnalysisJobMetadata(String jobName, String jobVersion, String jobDescription, String author, Date createdDate, Date updatedDate, String datastoreName, List<String> sourceColumnPaths, List<ColumnType> sourceColumnTypes, Map<String, String> variables, Map<String, String> properties) {
        this._jobName = jobName;
        this._jobVersion = jobVersion;
        this._jobDescription = jobDescription;
        this._author = author;
        this._createdDate = createdDate;
        this._updatedDate = updatedDate;
        this._datastoreName = datastoreName;
        this._properties = properties == null ? Collections.emptyMap() : ImmutableMap.copyOf(properties);
        this._sourceColumnPaths = sourceColumnPaths == null ? Collections.emptyList() : ImmutableList.copyOf(sourceColumnPaths);
        this._sourceColumnTypes = sourceColumnTypes == null ? new ArrayList<ColumnType>(sourceColumnPaths.size()) : Collections.unmodifiableList(sourceColumnTypes);
        variables = variables == null ? Collections.emptyMap() : ImmutableMap.copyOf(variables);
        this._variables = Collections.unmodifiableMap(variables);
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._jobName);
        identifiers.add(this._jobVersion);
        identifiers.add(this._jobDescription);
        identifiers.add(this._author);
        identifiers.add(this._createdDate);
        identifiers.add(this._updatedDate);
        identifiers.add(this._datastoreName);
        identifiers.add(this._sourceColumnPaths);
        identifiers.add(this._variables);
        identifiers.add(this._properties);
    }

    public String getJobName() {
        return this._jobName;
    }

    public String getJobVersion() {
        return this._jobVersion;
    }

    public String getJobDescription() {
        return this._jobDescription;
    }

    public String getAuthor() {
        return this._author;
    }

    public Date getCreatedDate() {
        return this._createdDate;
    }

    public Date getUpdatedDate() {
        return this._updatedDate;
    }

    public String getDatastoreName() {
        return this._datastoreName;
    }

    public List<String> getSourceColumnPaths() {
        return this._sourceColumnPaths;
    }

    public Map<String, String> getVariables() {
        return this._variables;
    }

    public List<ColumnType> getSourceColumnTypes() {
        return this._sourceColumnTypes;
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }
}

