/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.util.BaseObject;
import org.datacleaner.api.InputColumn;
import org.datacleaner.descriptors.AnalyzerDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.util.CollectionUtils2;

public final class ImmutableAnalyzerJob
extends BaseObject
implements AnalyzerJob {
    private static final long serialVersionUID = 1L;
    private final String _name;
    private final AnalyzerDescriptor<?> _descriptor;
    private final ComponentConfiguration _beanConfiguration;
    private final ComponentRequirement _componentRequirement;
    private final Map<String, String> _metadataProperties;

    public ImmutableAnalyzerJob(String name, AnalyzerDescriptor<?> descriptor, ComponentConfiguration beanConfiguration, ComponentRequirement requirement, Map<String, String> metadataProperties) {
        this._name = name;
        this._descriptor = descriptor;
        this._beanConfiguration = beanConfiguration;
        this._componentRequirement = requirement;
        this._metadataProperties = metadataProperties == null ? Collections.emptyMap() : ImmutableMap.copyOf(metadataProperties);
    }

    public Map<String, String> getMetadataProperties() {
        return this._metadataProperties;
    }

    public ComponentRequirement getComponentRequirement() {
        return this._componentRequirement;
    }

    public String getName() {
        return this._name;
    }

    public AnalyzerDescriptor<?> getDescriptor() {
        return this._descriptor;
    }

    public ComponentConfiguration getConfiguration() {
        return this._beanConfiguration;
    }

    public InputColumn<?>[] getInput() {
        ArrayList<InputColumn> result = new ArrayList<InputColumn>();
        Set propertiesForInput = this._descriptor.getConfiguredPropertiesForInput();
        for (ConfiguredPropertyDescriptor propertyDescriptor : propertiesForInput) {
            Object property = this._beanConfiguration.getProperty(propertyDescriptor);
            InputColumn[] inputs = CollectionUtils2.arrayOf(InputColumn.class, property);
            if (inputs == null) continue;
            for (InputColumn inputColumn : inputs) {
                result.add(inputColumn);
            }
        }
        return result.toArray(new InputColumn[result.size()]);
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._name);
        identifiers.add(this._beanConfiguration);
        identifiers.add(this._descriptor);
        identifiers.add(this._componentRequirement);
    }

    public String toString() {
        return "ImmutableAnalyzerJob[name=" + this._name + ",analyzer=" + this._descriptor.getDisplayName() + "]";
    }
}

