/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.util.EqualsBuilder;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.descriptors.PropertyDescriptor;
import org.datacleaner.job.ComponentConfiguration;

public final class ImmutableComponentConfiguration
implements ComponentConfiguration {
    private static final long serialVersionUID = 1L;
    private final Map<PropertyDescriptor, Object> _properties;
    private final transient Map<PropertyDescriptor, Object> _transientProperties;

    public ImmutableComponentConfiguration(Map<? extends PropertyDescriptor, Object> properties) {
        if (properties == null) {
            this._properties = ImmutableMap.of();
            this._transientProperties = null;
        } else {
            HashMap<PropertyDescriptor, Object> serializableProperties = new HashMap<PropertyDescriptor, Object>();
            HashMap<PropertyDescriptor, Object> transientProperties = new HashMap<PropertyDescriptor, Object>();
            for (Map.Entry<? extends PropertyDescriptor, Object> entry : properties.entrySet()) {
                PropertyDescriptor key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    throw new IllegalArgumentException("Collection values are not allowed in BeanConfigurations. Violating entry: " + key + " -> " + value);
                }
                if (value instanceof Serializable) {
                    serializableProperties.put(key, value);
                    continue;
                }
                transientProperties.put(key, value);
            }
            this._properties = ImmutableMap.copyOf(serializableProperties);
            this._transientProperties = ImmutableMap.copyOf(transientProperties);
        }
    }

    public Object getProperty(ConfiguredPropertyDescriptor propertyDescriptor) {
        Object result = this._properties.get(propertyDescriptor);
        if (result == null && this._transientProperties != null) {
            return this._transientProperties.get(propertyDescriptor);
        }
        return result;
    }

    public String toString() {
        return "ImmutableBeanConfiguration[" + this._properties + "]";
    }

    public int hashCode() {
        int prime = 31;
        return 31 + this._properties.size() + this._properties.keySet().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableComponentConfiguration other = (ImmutableComponentConfiguration)obj;
        Map<PropertyDescriptor, Object> otherProperties = other._properties;
        Set<PropertyDescriptor> configredProperties = this._properties.keySet();
        if (!configredProperties.equals(otherProperties.keySet())) {
            return false;
        }
        for (PropertyDescriptor propertyDescriptor : configredProperties) {
            Object value2;
            Object value1 = this._properties.get(propertyDescriptor);
            boolean equals = EqualsBuilder.equals((Object)value1, (Object)(value2 = otherProperties.get(propertyDescriptor)));
            if (equals) continue;
            return false;
        }
        return true;
    }
}

