/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.util.BaseObject;
import org.datacleaner.api.InputColumn;
import org.datacleaner.data.MutableInputColumn;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.descriptors.TransformerDescriptor;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.TransformerJob;
import org.datacleaner.util.CollectionUtils2;

public final class ImmutableTransformerJob
extends BaseObject
implements TransformerJob {
    private static final long serialVersionUID = 1L;
    private final String _name;
    private final TransformerDescriptor<?> _descriptor;
    private final ComponentConfiguration _beanConfiguration;
    private final List<MutableInputColumn<?>> _output;
    private final ComponentRequirement _componentRequirement;
    private final Map<String, String> _metadataProperties;

    public ImmutableTransformerJob(String name, TransformerDescriptor<?> descriptor, ComponentConfiguration beanConfiguration, Collection<MutableInputColumn<?>> output, ComponentRequirement requirement, Map<String, String> metadataProperties) {
        this._name = name;
        this._descriptor = descriptor;
        this._beanConfiguration = beanConfiguration;
        this._output = Collections.unmodifiableList(new ArrayList(output));
        this._componentRequirement = requirement;
        this._metadataProperties = metadataProperties == null ? Collections.emptyMap() : ImmutableMap.copyOf(metadataProperties);
    }

    public Map<String, String> getMetadataProperties() {
        return this._metadataProperties;
    }

    public String getName() {
        return this._name;
    }

    public TransformerDescriptor<?> getDescriptor() {
        return this._descriptor;
    }

    public ComponentConfiguration getConfiguration() {
        return this._beanConfiguration;
    }

    public InputColumn<?>[] getInput() {
        LinkedList<InputColumn> result = new LinkedList<InputColumn>();
        Set propertiesForInput = this._descriptor.getConfiguredPropertiesForInput();
        for (ConfiguredPropertyDescriptor propertyDescriptor : propertiesForInput) {
            Object property = this._beanConfiguration.getProperty(propertyDescriptor);
            InputColumn[] inputs = CollectionUtils2.arrayOf(InputColumn.class, property);
            if (inputs == null) continue;
            for (InputColumn inputColumn : inputs) {
                result.add(inputColumn);
            }
        }
        return result.toArray(new InputColumn[result.size()]);
    }

    public MutableInputColumn<?>[] getOutput() {
        return this._output.toArray(new MutableInputColumn[this._output.size()]);
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._name);
        identifiers.add(this._beanConfiguration);
        identifiers.add(this._descriptor);
        identifiers.add(this._output);
        identifiers.add(this._componentRequirement);
    }

    public String toString() {
        return "ImmutableTransformerJob[name=" + this._name + ",transformer=" + this._descriptor.getDisplayName() + "]";
    }

    public ComponentRequirement getComponentRequirement() {
        return this._componentRequirement;
    }
}

