/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.datacleaner.job.IdGenerator;

public final class PrefixedIdGenerator
implements IdGenerator {
    private final String prefix;
    private final AtomicInteger counter;
    private final String idNumberPattern;

    public PrefixedIdGenerator() {
        this("");
    }

    public PrefixedIdGenerator(String prefix) {
        this(prefix, 4);
    }

    public PrefixedIdGenerator(String prefix, int idNumberSize) {
        if (idNumberSize <= 0) {
            throw new IllegalArgumentException("idNumberSize must be a postive integer");
        }
        this.prefix = prefix;
        this.counter = new AtomicInteger(0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < idNumberSize; ++i) {
            sb.append('0');
        }
        this.idNumberPattern = sb.toString();
    }

    @Override
    public String nextId() {
        int i = this.counter.incrementAndGet();
        DecimalFormat format = new DecimalFormat(this.idNumberPattern);
        return this.prefix + format.format(i);
    }
}

