/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.builder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.EqualsBuilder;
import org.datacleaner.api.Component;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.Renderable;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.HasComponentRequirement;
import org.datacleaner.job.HasFilterOutcomes;
import org.datacleaner.job.ImmutableComponentConfiguration;
import org.datacleaner.job.SimpleComponentRequirement;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.builder.ComponentRemovalListener;
import org.datacleaner.job.builder.FilterComponentBuilder;
import org.datacleaner.job.builder.UnconfiguredConfiguredPropertyException;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.util.CollectionUtils2;
import org.datacleaner.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponentBuilder<D extends ComponentDescriptor<E>, E extends Component, B extends ComponentBuilder>
implements ComponentBuilder,
Renderable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractComponentBuilder.class);
    private final List<ComponentRemovalListener<ComponentBuilder>> _removalListeners;
    private final D _descriptor;
    private final E _configurableBean;
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final Map<String, String> _metadataProperties;
    private ComponentRequirement _componentRequirement;
    private String _name;

    public AbstractComponentBuilder(AnalysisJobBuilder analysisJobBuilder, D descriptor, Class<?> builderClass) {
        if (analysisJobBuilder == null) {
            throw new IllegalArgumentException("analysisJobBuilder cannot be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        if (builderClass == null) {
            throw new IllegalArgumentException("builderClass cannot be null");
        }
        this._analysisJobBuilder = analysisJobBuilder;
        this._descriptor = descriptor;
        if (!ReflectionUtils.is(this.getClass(), builderClass)) {
            throw new IllegalArgumentException("Builder class does not correspond to actual class of builder");
        }
        this._configurableBean = (Component)ReflectionUtils.newInstance(this._descriptor.getComponentClass());
        this._metadataProperties = new LinkedHashMap<String, String>();
        this._removalListeners = new ArrayList<ComponentRemovalListener<ComponentBuilder>>(1);
    }

    @Override
    public final Map<String, String> getMetadataProperties() {
        return this._metadataProperties;
    }

    @Override
    public final String getMetadataProperty(String key) {
        return this._metadataProperties.get(key);
    }

    @Override
    public final void setMetadataProperty(String key, String value) {
        this._metadataProperties.put(key, value);
    }

    @Override
    public void setMetadataProperties(Map<String, String> metadataProperties) {
        this._metadataProperties.clear();
        if (metadataProperties != null) {
            this._metadataProperties.putAll(metadataProperties);
        }
    }

    @Override
    public final void removeMetadataProperty(String key) {
        this._metadataProperties.remove(key);
    }

    @Override
    public final AnalysisJobBuilder getAnalysisJobBuilder() {
        return this._analysisJobBuilder;
    }

    public final D getDescriptor() {
        return this._descriptor;
    }

    public final E getComponentInstance() {
        return this._configurableBean;
    }

    @Deprecated
    public final E getConfigurableBean() {
        return this.getComponentInstance();
    }

    @Override
    public void setConfiguredProperties(Map<ConfiguredPropertyDescriptor, Object> configuredPropeties) {
        ImmutableComponentConfiguration beanConfiguration = new ImmutableComponentConfiguration(configuredPropeties);
        this.setConfiguredProperties(beanConfiguration);
    }

    @Override
    public void setConfiguredProperties(ComponentConfiguration configuration) {
        boolean changed = false;
        Set properties = this.getDescriptor().getConfiguredProperties();
        for (ConfiguredPropertyDescriptor property : properties) {
            Object value;
            boolean changedValue = this.setConfiguredPropertyIfChanged(property, value = configuration.getProperty(property));
            if (!changedValue) continue;
            changed = true;
        }
        if (changed) {
            this.onConfigurationChanged();
        }
    }

    @Override
    public final boolean isConfigured(boolean throwException) throws IllegalStateException, UnconfiguredConfiguredPropertyException {
        for (ConfiguredPropertyDescriptor configuredProperty : this._descriptor.getConfiguredProperties()) {
            if (this.isConfigured(configuredProperty, throwException)) continue;
            if (throwException) {
                throw new UnconfiguredConfiguredPropertyException(this, configuredProperty);
            }
            return false;
        }
        try {
            LifeCycleHelper lifeCycleHelper = new LifeCycleHelper(null, null, false);
            lifeCycleHelper.validate((ComponentDescriptor<?>)this.getDescriptor(), this.getConfigurableBean());
        }
        catch (RuntimeException e) {
            if (throwException) {
                throw e;
            }
            return false;
        }
        return true;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public boolean isConfigured() {
        return this.isConfigured(false);
    }

    @Override
    public boolean isConfigured(ConfiguredPropertyDescriptor configuredProperty, boolean throwException) throws UnconfiguredConfiguredPropertyException {
        if (configuredProperty.isRequired()) {
            Map<ConfiguredPropertyDescriptor, Object> configuredProperties = this.getConfiguredProperties();
            Object value = configuredProperties.get(configuredProperty);
            if (configuredProperty.isArray() && value != null && Array.getLength(value) == 0) {
                value = null;
            }
            if (value == null) {
                if (throwException) {
                    throw new UnconfiguredConfiguredPropertyException(this, configuredProperty);
                }
                logger.debug("Configured property is not set: " + configuredProperty);
                return false;
            }
        }
        return true;
    }

    public B setConfiguredProperty(String configuredName, Object value) {
        ConfiguredPropertyDescriptor configuredProperty = this._descriptor.getConfiguredProperty(configuredName);
        if (configuredProperty == null) {
            throw new IllegalArgumentException("No such configured property: " + configuredName);
        }
        return this.setConfiguredProperty(configuredProperty, value);
    }

    public B setConfiguredProperty(ConfiguredPropertyDescriptor configuredProperty, Object value) {
        boolean changed = this.setConfiguredPropertyIfChanged(configuredProperty, value);
        if (changed) {
            this.onConfigurationChanged();
        }
        return (B)this;
    }

    protected boolean setConfiguredPropertyIfChanged(ConfiguredPropertyDescriptor configuredProperty, Object value) {
        if (configuredProperty == null) {
            throw new IllegalArgumentException("configuredProperty cannot be null");
        }
        Object currentValue = configuredProperty.getValue(this._configurableBean);
        if (EqualsBuilder.equals((Object)currentValue, (Object)value)) {
            return false;
        }
        if (value != null) {
            boolean correctType = true;
            if (configuredProperty.isArray()) {
                if (value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        Object valuePart = Array.get(value, i);
                        if (valuePart == null) {
                            logger.warn("Element no. {} in array (size {}) is null! Value passed to {}", new Object[]{i, length, configuredProperty});
                            continue;
                        }
                        if (ReflectionUtils.is(valuePart.getClass(), configuredProperty.getBaseType())) continue;
                        correctType = false;
                    }
                } else if (!ReflectionUtils.is(value.getClass(), configuredProperty.getBaseType())) {
                    correctType = false;
                }
            } else if (!ReflectionUtils.is(value.getClass(), configuredProperty.getBaseType())) {
                correctType = false;
            }
            if (!correctType) {
                throw new IllegalArgumentException("Invalid value type: " + value.getClass().getName() + ", expected: " + configuredProperty.getBaseType().getName());
            }
        }
        configuredProperty.setValue(this._configurableBean, value);
        return true;
    }

    @Override
    public Map<ConfiguredPropertyDescriptor, Object> getConfiguredProperties() {
        HashMap<ConfiguredPropertyDescriptor, Object> map = new HashMap<ConfiguredPropertyDescriptor, Object>();
        Set configuredProperties = this.getDescriptor().getConfiguredProperties();
        for (ConfiguredPropertyDescriptor propertyDescriptor : configuredProperties) {
            Object value = this.getConfiguredProperty(propertyDescriptor);
            if (value == null) continue;
            map.put(propertyDescriptor, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public void onRequirementChanged() {
    }

    public void onConfigurationChanged() {
    }

    @Override
    public Object getConfiguredProperty(ConfiguredPropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getValue(this.getConfigurableBean());
    }

    @Override
    public void clearInputColumns() {
        Set configuredProperties = this.getDescriptor().getConfiguredPropertiesForInput();
        for (ConfiguredPropertyDescriptor configuredProperty : configuredProperties) {
            if (configuredProperty.isArray()) {
                this.setConfiguredProperty(configuredProperty, (Object)new InputColumn[0]);
                continue;
            }
            this.setConfiguredProperty(configuredProperty, null);
        }
    }

    public B addInputColumn(InputColumn<?> inputColumn) throws IllegalArgumentException {
        ConfiguredPropertyDescriptor propertyDescriptor = this.getDefaultConfiguredPropertyForInput();
        return this.addInputColumn(inputColumn, propertyDescriptor);
    }

    @Override
    public ConfiguredPropertyDescriptor getDefaultConfiguredPropertyForInput() throws UnsupportedOperationException {
        Set inputProperties = this.getDescriptor().getConfiguredPropertiesForInput(false);
        if (inputProperties.isEmpty()) {
            inputProperties = this.getDescriptor().getConfiguredPropertiesForInput(true);
        }
        if (inputProperties.size() == 1) {
            ConfiguredPropertyDescriptor propertyDescriptor = (ConfiguredPropertyDescriptor)inputProperties.iterator().next();
            return propertyDescriptor;
        }
        throw new UnsupportedOperationException("There are " + inputProperties.size() + " named input columns in \"" + this.getDescriptor().getDisplayName() + "\", please specify which one to configure");
    }

    public B addInputColumn(InputColumn<?> inputColumn, ConfiguredPropertyDescriptor propertyDescriptor) throws IllegalArgumentException {
        Class actualDataType;
        if (propertyDescriptor == null || !propertyDescriptor.isInputColumn()) {
            throw new IllegalArgumentException("Property is not of InputColumn type: " + propertyDescriptor);
        }
        Class expectedDataType = propertyDescriptor.getTypeArgument(0);
        if (expectedDataType != null && expectedDataType != Object.class && !ReflectionUtils.is(actualDataType = inputColumn.getDataType(), expectedDataType, false)) {
            throw new IllegalArgumentException("Unsupported InputColumn type: " + actualDataType + ", expected: " + expectedDataType);
        }
        InputColumn[] inputColumns = this.getConfiguredProperty(propertyDescriptor);
        inputColumns = inputColumns == null ? (propertyDescriptor.isArray() ? new InputColumn[]{inputColumn} : inputColumn) : CollectionUtils2.array(InputColumn.class, inputColumns, new InputColumn[]{inputColumn});
        this.setConfiguredProperty(propertyDescriptor, (Object)inputColumns);
        return (B)this;
    }

    public B addInputColumns(Collection<? extends InputColumn<?>> inputColumns, ConfiguredPropertyDescriptor propertyDescriptor) {
        InputColumn<?> asArray;
        InputColumn<?> newInputColumns;
        if (propertyDescriptor == null || !propertyDescriptor.isInputColumn()) {
            throw new IllegalArgumentException("Property is not of InputColumn type: " + propertyDescriptor);
        }
        Class expectedDataType = propertyDescriptor.getTypeArgument(0);
        if (expectedDataType != null && expectedDataType != Object.class) {
            for (InputColumn<?> inputColumn : inputColumns) {
                Class actualDataType = inputColumn.getDataType();
                if (ReflectionUtils.is(actualDataType, expectedDataType, false)) continue;
                throw new IllegalArgumentException("Unsupported InputColumn type: " + actualDataType + ", expected: " + expectedDataType);
            }
        }
        if ((newInputColumns = this.getConfiguredProperty(propertyDescriptor)) == null) {
            if (propertyDescriptor.isArray()) {
                newInputColumns = asArray = inputColumns.toArray(new InputColumn[inputColumns.size()]);
            } else if (inputColumns == null || inputColumns.isEmpty()) {
                newInputColumns = null;
            } else {
                if (inputColumns.size() > 1) {
                    throw new IllegalArgumentException("Property type is a single InputColumn, but a collection of more than one element was given");
                }
                newInputColumns = inputColumns.iterator().next();
            }
        } else {
            asArray = inputColumns.toArray(new InputColumn[inputColumns.size()]);
            newInputColumns = CollectionUtils2.array(InputColumn.class, newInputColumns, asArray);
        }
        this.setConfiguredProperty(propertyDescriptor, (Object)newInputColumns);
        return (B)this;
    }

    public B addInputColumns(Collection<? extends InputColumn<?>> inputColumns) {
        ConfiguredPropertyDescriptor propertyDescriptor = this.getDefaultConfiguredPropertyForInput();
        this.addInputColumns(inputColumns, propertyDescriptor);
        return (B)this;
    }

    public B addInputColumns(InputColumn<?> ... inputColumns) {
        List<InputColumn<?>> list = Arrays.asList(inputColumns);
        ConfiguredPropertyDescriptor propertyDescriptor = this.getDefaultConfiguredPropertyForInput();
        this.addInputColumns(list, propertyDescriptor);
        return (B)this;
    }

    public B removeInputColumn(InputColumn<?> inputColumn) {
        Set propertyDescriptors = this.getDescriptor().getConfiguredPropertiesForInput();
        if (propertyDescriptors.size() == 1) {
            ConfiguredPropertyDescriptor propertyDescriptor = (ConfiguredPropertyDescriptor)propertyDescriptors.iterator().next();
            return this.removeInputColumn(inputColumn, propertyDescriptor);
        }
        throw new UnsupportedOperationException("There are " + propertyDescriptors.size() + " named input columns, please specify which one to configure");
    }

    public B removeInputColumn(InputColumn<?> inputColumn, ConfiguredPropertyDescriptor propertyDescriptor) {
        Object inputColumns = this.getConfiguredProperty(propertyDescriptor);
        if (inputColumns != null) {
            if (inputColumns == inputColumn) {
                inputColumns = null;
            } else if (inputColumns.getClass().isArray()) {
                inputColumns = CollectionUtils.arrayRemove((Object)inputColumns, inputColumn);
            }
            this.setConfiguredProperty(propertyDescriptor, inputColumns);
            propertyDescriptor.setValue(this.getComponentInstance(), inputColumns);
        }
        return (B)this;
    }

    public void setRequirement(FilterComponentBuilder<?, ?> filterComponentBuilder, String category) {
        FilterOutcome filterOutcome = filterComponentBuilder.getFilterOutcome(category);
        if (filterOutcome == null) {
            throw new IllegalArgumentException("No such category found in available outcomes: " + category);
        }
        this.setRequirement(filterOutcome);
    }

    public void setRequirement(FilterComponentBuilder<?, ?> filterJobBuilder, Enum<?> category) {
        EnumSet categories = ((FilterDescriptor)filterJobBuilder.getDescriptor()).getOutcomeCategories();
        if (!categories.contains(category)) {
            throw new IllegalArgumentException("No such category found in available outcomes: " + category);
        }
        this.setRequirement(filterJobBuilder.getFilterOutcome(category));
    }

    public void setRequirement(FilterOutcome outcome) throws IllegalArgumentException {
        if (!this.validateRequirementCandidate(outcome)) {
            throw new IllegalArgumentException("Cyclic dependency detected when setting requirement: " + outcome);
        }
        if (outcome == null) {
            this.setComponentRequirement(null);
        } else if (outcome instanceof FilterOutcome) {
            this.setComponentRequirement(new SimpleComponentRequirement(outcome));
        } else {
            throw new IllegalArgumentException("Unsupported outcome type (use ComponentRequirement instead): " + outcome);
        }
    }

    @Override
    public void setComponentRequirement(ComponentRequirement requirement) {
        if (!EqualsBuilder.equals((Object)this._componentRequirement, (Object)requirement)) {
            this._componentRequirement = requirement;
            this.onRequirementChanged();
        }
    }

    public boolean validateRequirementSource(HasFilterOutcomes outcomeSource) {
        if (outcomeSource == null) {
            return true;
        }
        Collection outcomes = outcomeSource.getFilterOutcomes();
        if (outcomes == null || outcomes.isEmpty()) {
            return true;
        }
        FilterOutcome firstOutcome = (FilterOutcome)outcomes.iterator().next();
        return this.validateRequirementCandidate(firstOutcome);
    }

    public boolean validateRequirementCandidate(ComponentRequirement requirement) {
        if (requirement instanceof SimpleComponentRequirement) {
            SimpleComponentRequirement simpleComponentRequirement = (SimpleComponentRequirement)requirement;
            FilterOutcome outcome = simpleComponentRequirement.getOutcome();
            return this.validateRequirementCandidate(outcome);
        }
        return true;
    }

    public boolean validateRequirementCandidate(FilterOutcome requirement) {
        ComponentRequirement componentRequirement;
        if (requirement == null) {
            return true;
        }
        HasFilterOutcomes source = requirement.getSource();
        if (source == this) {
            return false;
        }
        if (source instanceof HasComponentRequirement && (componentRequirement = ((HasComponentRequirement)source).getComponentRequirement()) != null) {
            Collection requirements = componentRequirement.getProcessingDependencies();
            for (FilterOutcome transitiveRequirement : requirements) {
                boolean transitiveValidation = this.validateRequirementCandidate(transitiveRequirement);
                if (transitiveValidation) continue;
                return false;
            }
        }
        return true;
    }

    public List<InputColumn<?>> getInputColumns() {
        LinkedList<InputColumn> result = new LinkedList<InputColumn>();
        Set configuredPropertiesForInput = this.getDescriptor().getConfiguredPropertiesForInput();
        for (ConfiguredPropertyDescriptor configuredProperty : configuredPropertiesForInput) {
            Object inputColumns = this.getConfiguredProperty(configuredProperty);
            if (inputColumns == null) continue;
            if (inputColumns.getClass().isArray()) {
                int length = Array.getLength(inputColumns);
                for (int i = 0; i < length; ++i) {
                    InputColumn column = (InputColumn)Array.get(inputColumns, i);
                    if (column == null) {
                        logger.warn("Element no. {} in array (size {}) is null! Value read from {}", new Object[]{i, length, configuredProperty});
                        continue;
                    }
                    result.add(column);
                }
                continue;
            }
            result.add((InputColumn)inputColumns);
        }
        return Collections.unmodifiableList(result);
    }

    public ComponentRequirement getComponentRequirement() {
        return this._componentRequirement;
    }

    public InputColumn<?>[] getInput() {
        List<InputColumn<?>> inputColumns = this.getInputColumns();
        return inputColumns.toArray(new InputColumn[inputColumns.size()]);
    }

    protected final void onRemoved() {
        this.onRemovedInternal();
        for (ComponentRemovalListener<ComponentBuilder> removalListener : this._removalListeners) {
            removalListener.onRemove(this);
        }
    }

    protected abstract void onRemovedInternal();

    @Override
    public void addRemovalListener(ComponentRemovalListener<ComponentBuilder> componentRemovalListener) {
        this._removalListeners.add(componentRemovalListener);
    }

    @Override
    public boolean removeRemovalListener(ComponentRemovalListener<ComponentBuilder> componentRemovalListener) {
        return this._removalListeners.remove(componentRemovalListener);
    }
}

