/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.builder;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.Predicate;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.Filter;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.Transformer;
import org.datacleaner.configuration.AnalyzerBeansConfiguration;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.SchemaNavigator;
import org.datacleaner.data.MetaModelInputColumn;
import org.datacleaner.data.MutableInputColumn;
import org.datacleaner.descriptors.AnalyzerDescriptor;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.descriptors.DescriptorProvider;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.descriptors.TransformerDescriptor;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalysisJobImmutabilizer;
import org.datacleaner.job.AnalysisJobMetadata;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterJob;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.IdGenerator;
import org.datacleaner.job.ImmutableAnalysisJob;
import org.datacleaner.job.ImmutableAnalysisJobMetadata;
import org.datacleaner.job.InputColumnSourceJob;
import org.datacleaner.job.PrefixedIdGenerator;
import org.datacleaner.job.SimpleComponentRequirement;
import org.datacleaner.job.TransformerJob;
import org.datacleaner.job.builder.AbstractComponentBuilder;
import org.datacleaner.job.builder.AnalysisJobBuilderImportHelper;
import org.datacleaner.job.builder.AnalyzerChangeListener;
import org.datacleaner.job.builder.AnalyzerComponentBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.builder.FilterChangeListener;
import org.datacleaner.job.builder.FilterComponentBuilder;
import org.datacleaner.job.builder.LazyFilterOutcome;
import org.datacleaner.job.builder.MutableAnalysisJobMetadata;
import org.datacleaner.job.builder.SourceColumnChangeListener;
import org.datacleaner.job.builder.TransformerChangeListener;
import org.datacleaner.job.builder.TransformerComponentBuilder;
import org.datacleaner.job.builder.UnconfiguredConfiguredPropertyException;
import org.datacleaner.util.SourceColumnFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalysisJobBuilder
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisJobBuilder.class);
    private final AnalyzerBeansConfiguration _configuration;
    private final IdGenerator _transformedColumnIdGenerator;
    private Datastore _datastore;
    private DatastoreConnection _datastoreConnection;
    private final List<MetaModelInputColumn> _sourceColumns;
    private final List<FilterComponentBuilder<?, ?>> _filterComponentBuilders;
    private final List<TransformerComponentBuilder<?>> _transformerComponentBuilders;
    private final List<AnalyzerComponentBuilder<?>> _analyzerComponentBuilders;
    private MutableAnalysisJobMetadata _analysisJobMetadata;
    private final List<SourceColumnChangeListener> _sourceColumnListeners = new ArrayList<SourceColumnChangeListener>();
    private final List<AnalyzerChangeListener> _analyzerChangeListeners = new ArrayList<AnalyzerChangeListener>();
    private final List<TransformerChangeListener> _transformerChangeListeners = new ArrayList<TransformerChangeListener>();
    private final List<FilterChangeListener> _filterChangeListeners = new ArrayList<FilterChangeListener>();
    private ComponentRequirement _defaultRequirement;

    public AnalysisJobBuilder(AnalyzerBeansConfiguration configuration) {
        this._configuration = configuration;
        this._transformedColumnIdGenerator = new PrefixedIdGenerator("");
        this._sourceColumns = new ArrayList<MetaModelInputColumn>();
        this._filterComponentBuilders = new ArrayList();
        this._transformerComponentBuilders = new ArrayList();
        this._analyzerComponentBuilders = new ArrayList();
    }

    private AnalysisJobBuilder(AnalyzerBeansConfiguration configuration, Datastore datastore, DatastoreConnection datastoreConnection, MutableAnalysisJobMetadata metadata, List<MetaModelInputColumn> sourceColumns, ComponentRequirement defaultRequirement, IdGenerator idGenerator, List<TransformerComponentBuilder<?>> transformerJobBuilders, List<FilterComponentBuilder<?, ?>> filterJobBuilders, List<AnalyzerComponentBuilder<?>> analyzerJobBuilders) {
        this._configuration = configuration;
        this._datastore = datastore;
        this._analysisJobMetadata = metadata;
        this._datastoreConnection = datastoreConnection;
        this._sourceColumns = sourceColumns;
        this._defaultRequirement = defaultRequirement;
        this._transformedColumnIdGenerator = idGenerator;
        this._filterComponentBuilders = filterJobBuilders;
        this._transformerComponentBuilders = transformerJobBuilders;
        this._analyzerComponentBuilders = analyzerJobBuilders;
    }

    public AnalysisJobBuilder(AnalyzerBeansConfiguration configuration, AnalysisJob job) {
        this(configuration);
        this.importJob(job);
    }

    public AnalysisJobBuilder setDatastore(String datastoreName) {
        Datastore datastore = this._configuration.getDatastoreCatalog().getDatastore(datastoreName);
        if (datastore == null) {
            throw new IllegalArgumentException("No such datastore: " + datastoreName);
        }
        return this.setDatastore(datastore);
    }

    public Datastore getDatastore() {
        return this._datastore;
    }

    public AnalysisJobBuilder setDatastore(Datastore datastore) {
        this._datastore = datastore;
        DatastoreConnection datastoreConnection = datastore == null ? null : datastore.openConnection();
        return this.setDatastoreConnection(datastoreConnection);
    }

    public MutableAnalysisJobMetadata getAnalysisJobMetadata() {
        if (this._analysisJobMetadata == null) {
            this._analysisJobMetadata = new MutableAnalysisJobMetadata();
        }
        return this._analysisJobMetadata;
    }

    public AnalysisJobBuilder setAnalysisJobMetadata(AnalysisJobMetadata analysisJobMetadata) {
        if (analysisJobMetadata == null) {
            analysisJobMetadata = AnalysisJobMetadata.EMPTY_METADATA;
        }
        this._analysisJobMetadata = analysisJobMetadata instanceof MutableAnalysisJobMetadata ? (MutableAnalysisJobMetadata)analysisJobMetadata : new MutableAnalysisJobMetadata(analysisJobMetadata);
        return this;
    }

    public AnalysisJobBuilder setDatastoreConnection(DatastoreConnection datastoreConnection) {
        Datastore datastore;
        if (this._datastoreConnection != null) {
            this._datastoreConnection.close();
        }
        this._datastoreConnection = datastoreConnection;
        if (datastoreConnection != null && this._datastore == null && (datastore = datastoreConnection.getDatastore()) != null) {
            this.setDatastore(datastore);
        }
        return this;
    }

    public DatastoreConnection getDatastoreConnection() {
        return this._datastoreConnection;
    }

    public AnalyzerBeansConfiguration getConfiguration() {
        return this._configuration;
    }

    public AnalysisJobBuilder addSourceColumn(Column column) {
        MetaModelInputColumn inputColumn = new MetaModelInputColumn(column);
        return this.addSourceColumn(inputColumn);
    }

    public AnalysisJobBuilder addSourceColumn(MetaModelInputColumn inputColumn) {
        if (!this._sourceColumns.contains(inputColumn)) {
            this._sourceColumns.add(inputColumn);
            ArrayList<SourceColumnChangeListener> listeners = new ArrayList<SourceColumnChangeListener>(this._sourceColumnListeners);
            for (SourceColumnChangeListener listener : listeners) {
                listener.onAdd(inputColumn);
            }
        }
        return this;
    }

    public AnalysisJobBuilder addSourceColumns(Collection<Column> columns) {
        for (Column column : columns) {
            this.addSourceColumn(column);
        }
        return this;
    }

    public AnalysisJobBuilder addSourceColumns(Column ... columns) {
        for (Column column : columns) {
            this.addSourceColumn(column);
        }
        return this;
    }

    public AnalysisJobBuilder addSourceColumns(MetaModelInputColumn ... inputColumns) {
        for (MetaModelInputColumn metaModelInputColumn : inputColumns) {
            this.addSourceColumn(metaModelInputColumn);
        }
        return this;
    }

    public AnalysisJobBuilder addSourceColumns(String ... columnNames) {
        if (this._datastoreConnection == null) {
            throw new IllegalStateException("Cannot add source columns by name when no Datastore or DatastoreConnection has been set");
        }
        SchemaNavigator schemaNavigator = this._datastoreConnection.getSchemaNavigator();
        Column[] columns = new Column[columnNames.length];
        for (int i = 0; i < columns.length; ++i) {
            String columnName = columnNames[i];
            Column column = schemaNavigator.convertToColumn(columnName);
            if (column == null) {
                throw new IllegalArgumentException("No such column: " + columnName);
            }
            columns[i] = column;
        }
        return this.addSourceColumns(columns);
    }

    public AnalysisJobBuilder removeSourceTable(Table table) {
        Column[] cols;
        for (Column col : cols = table.getColumns()) {
            this.removeSourceColumn(col);
        }
        return this;
    }

    public AnalysisJobBuilder removeSourceColumn(Column column) {
        MetaModelInputColumn inputColumn = new MetaModelInputColumn(column);
        return this.removeSourceColumn(inputColumn);
    }

    public void importJob(AnalysisJob job) {
        AnalysisJobBuilderImportHelper helper = new AnalysisJobBuilderImportHelper(this);
        helper.importJob(job);
    }

    public AnalysisJobBuilder removeSourceColumn(MetaModelInputColumn inputColumn) {
        boolean removed = this._sourceColumns.remove(inputColumn);
        if (removed) {
            ArrayList<SourceColumnChangeListener> listeners = new ArrayList<SourceColumnChangeListener>(this._sourceColumnListeners);
            for (SourceColumnChangeListener listener : listeners) {
                listener.onRemove(inputColumn);
            }
        }
        return this;
    }

    public boolean containsSourceColumn(Column column) {
        for (MetaModelInputColumn sourceColumn : this._sourceColumns) {
            if (!sourceColumn.getPhysicalColumn().equals(column)) continue;
            return true;
        }
        return false;
    }

    public List<MetaModelInputColumn> getSourceColumns() {
        return Collections.unmodifiableList(this._sourceColumns);
    }

    public List<MetaModelInputColumn> getSourceColumnsOfTable(Table table) {
        ArrayList<MetaModelInputColumn> result = new ArrayList<MetaModelInputColumn>();
        for (MetaModelInputColumn column : this._sourceColumns) {
            Column physicalColumn = column.getPhysicalColumn();
            if (physicalColumn == null || physicalColumn.getTable() != table) continue;
            result.add(column);
        }
        return result;
    }

    public <T extends Transformer> TransformerComponentBuilder<T> addTransformer(Class<T> transformerClass) {
        TransformerDescriptor<T> descriptor = this._configuration.getDescriptorProvider().getTransformerDescriptorForClass(transformerClass);
        if (descriptor == null) {
            throw new IllegalArgumentException("No descriptor found for: " + transformerClass);
        }
        return this.addTransformer(descriptor);
    }

    public List<TransformerComponentBuilder<?>> getTransformerComponentBuilders() {
        return Collections.unmodifiableList(this._transformerComponentBuilders);
    }

    public <T extends Transformer> TransformerComponentBuilder<T> addTransformer(TransformerDescriptor<T> descriptor) {
        return this.addTransformer(descriptor, null, null, null);
    }

    public <T extends Transformer> TransformerComponentBuilder<T> addTransformer(TransformerDescriptor<T> descriptor, Map<ConfiguredPropertyDescriptor, Object> configuredProperties, ComponentRequirement requirement, Map<String, String> metadataProperties) {
        TransformerComponentBuilder<T> transformer = new TransformerComponentBuilder<T>(this, descriptor, this._transformedColumnIdGenerator);
        this.initializeComponentBuilder(transformer, configuredProperties, requirement, metadataProperties);
        return this.addTransformer(transformer);
    }

    public <T extends Transformer> TransformerComponentBuilder<T> addTransformer(TransformerComponentBuilder<T> tjb) {
        if (tjb.getComponentRequirement() == null) {
            tjb.setComponentRequirement(this._defaultRequirement);
        }
        this._transformerComponentBuilders.add(tjb);
        ArrayList<TransformerChangeListener> listeners = new ArrayList<TransformerChangeListener>(this._transformerChangeListeners);
        for (TransformerChangeListener listener : listeners) {
            listener.onAdd(tjb);
        }
        return tjb;
    }

    public AnalysisJobBuilder removeTransformer(TransformerComponentBuilder<?> tjb) {
        boolean removed = this._transformerComponentBuilders.remove(tjb);
        if (removed) {
            tjb.onRemoved();
        }
        return this;
    }

    public ComponentBuilder addComponent(ComponentDescriptor<?> descriptor, Map<ConfiguredPropertyDescriptor, Object> configuredProperties, ComponentRequirement requirement, Map<String, String> metadataProperties) {
        if (descriptor instanceof FilterDescriptor) {
            return this.addFilter((FilterDescriptor)descriptor, configuredProperties, requirement, metadataProperties);
        }
        if (descriptor instanceof TransformerDescriptor) {
            return this.addTransformer((TransformerDescriptor)descriptor, configuredProperties, requirement, metadataProperties);
        }
        if (descriptor instanceof AnalyzerDescriptor) {
            return this.addAnalyzer((AnalyzerDescriptor)descriptor, configuredProperties, requirement, metadataProperties);
        }
        throw new UnsupportedOperationException("Unknown component type: " + descriptor);
    }

    public ComponentBuilder addComponent(ComponentDescriptor<?> descriptor) {
        AbstractComponentBuilder builder;
        if (descriptor instanceof FilterDescriptor) {
            builder = this.addFilter((FilterDescriptor)descriptor);
        } else if (descriptor instanceof TransformerDescriptor) {
            builder = this.addTransformer((TransformerDescriptor)descriptor);
        } else if (descriptor instanceof AnalyzerDescriptor) {
            builder = this.addAnalyzer((AnalyzerDescriptor)descriptor);
        } else {
            throw new UnsupportedOperationException("Unknown component type: " + descriptor);
        }
        return builder;
    }

    protected Object addComponent(ComponentJob componentJob) {
        ComponentDescriptor descriptor = componentJob.getDescriptor();
        ComponentBuilder builder = this.addComponent(descriptor);
        builder.setName(componentJob.getName());
        builder.setConfiguredProperties(componentJob.getConfiguration());
        builder.setMetadataProperties(componentJob.getMetadataProperties());
        if (componentJob instanceof InputColumnSourceJob) {
            InputColumn[] output = ((InputColumnSourceJob)componentJob).getOutput();
            TransformerComponentBuilder transformerJobBuilder = (TransformerComponentBuilder)builder;
            List<MutableInputColumn<?>> outputColumns = transformerJobBuilder.getOutputColumns();
            assert (output.length == outputColumns.size());
            for (int i = 0; i < output.length; ++i) {
                MutableInputColumn<?> mutableOutputColumn = outputColumns.get(i);
                mutableOutputColumn.setName(output[i].getName());
            }
        }
        return builder;
    }

    public <F extends Filter<C>, C extends Enum<C>> FilterComponentBuilder<F, C> addFilter(Class<F> filterClass) {
        FilterDescriptor descriptor = this._configuration.getDescriptorProvider().getFilterDescriptorForClass(filterClass);
        if (descriptor == null) {
            throw new IllegalArgumentException("No descriptor found for: " + filterClass);
        }
        return this.addFilter(descriptor);
    }

    public <F extends Filter<C>, C extends Enum<C>> FilterComponentBuilder<F, C> addFilter(FilterDescriptor<F, C> descriptor) {
        return this.addFilter(descriptor, null, null, null);
    }

    public <F extends Filter<C>, C extends Enum<C>> FilterComponentBuilder<F, C> addFilter(FilterDescriptor<F, C> descriptor, Map<ConfiguredPropertyDescriptor, Object> configuredProperties, ComponentRequirement requirement, Map<String, String> metadataProperties) {
        FilterComponentBuilder<F, C> filter = new FilterComponentBuilder<F, C>(this, descriptor);
        this.initializeComponentBuilder(filter, configuredProperties, requirement, metadataProperties);
        return this.addFilter(filter);
    }

    private void initializeComponentBuilder(ComponentBuilder component, Map<ConfiguredPropertyDescriptor, Object> configuredProperties, ComponentRequirement requirement, Map<String, String> metadataProperties) {
        if (configuredProperties != null) {
            component.setConfiguredProperties(configuredProperties);
        }
        if (requirement != null) {
            component.setComponentRequirement(requirement);
        }
        if (metadataProperties != null) {
            component.setMetadataProperties(metadataProperties);
        }
    }

    public <F extends Filter<C>, C extends Enum<C>> FilterComponentBuilder<F, C> addFilter(FilterComponentBuilder<F, C> fjb) {
        this._filterComponentBuilders.add(fjb);
        if (fjb.getComponentRequirement() == null) {
            fjb.setComponentRequirement(this._defaultRequirement);
        }
        ArrayList<FilterChangeListener> listeners = new ArrayList<FilterChangeListener>(this._filterChangeListeners);
        for (FilterChangeListener listener : listeners) {
            listener.onAdd(fjb);
        }
        return fjb;
    }

    public AnalysisJobBuilder removeFilter(FilterComponentBuilder<?, ?> filterJobBuilder) {
        boolean removed = this._filterComponentBuilders.remove(filterJobBuilder);
        if (removed) {
            ComponentRequirement previousRequirement = filterJobBuilder.getComponentRequirement();
            Collection<FilterOutcome> outcomes = filterJobBuilder.getFilterOutcomes();
            for (FilterOutcome outcome : outcomes) {
                ComponentRequirement requirement;
                if (this._defaultRequirement != null && this._defaultRequirement.getProcessingDependencies().contains(outcome)) {
                    this.setDefaultRequirement((ComponentRequirement)null);
                }
                for (AnalyzerComponentBuilder<?> analyzerComponentBuilder : this._analyzerComponentBuilders) {
                    requirement = analyzerComponentBuilder.getComponentRequirement();
                    if (requirement == null || !requirement.getProcessingDependencies().contains(outcome)) continue;
                    analyzerComponentBuilder.setComponentRequirement(previousRequirement);
                }
                for (TransformerComponentBuilder transformerComponentBuilder : this._transformerComponentBuilders) {
                    requirement = transformerComponentBuilder.getComponentRequirement();
                    if (requirement == null || !requirement.getProcessingDependencies().contains(outcome)) continue;
                    transformerComponentBuilder.setComponentRequirement(previousRequirement);
                }
                for (FilterComponentBuilder filterComponentBuilder : this._filterComponentBuilders) {
                    requirement = filterComponentBuilder.getComponentRequirement();
                    if (requirement == null || !requirement.getProcessingDependencies().contains(outcome)) continue;
                    filterComponentBuilder.setComponentRequirement(previousRequirement);
                }
            }
            filterJobBuilder.onRemoved();
        }
        return this;
    }

    public List<AnalyzerComponentBuilder<?>> getAnalyzerComponentBuilders() {
        return Collections.unmodifiableList(this._analyzerComponentBuilders);
    }

    public List<FilterComponentBuilder<?, ?>> getFilterComponentBuilders() {
        return Collections.unmodifiableList(this._filterComponentBuilders);
    }

    public <A extends Analyzer<?>> AnalyzerComponentBuilder<A> addAnalyzer(AnalyzerDescriptor<A> descriptor) {
        return this.addAnalyzer(descriptor, null, null, null);
    }

    public <A extends Analyzer<?>> AnalyzerComponentBuilder<A> addAnalyzer(AnalyzerDescriptor<A> descriptor, Map<ConfiguredPropertyDescriptor, Object> configuredProperties, ComponentRequirement requirement, Map<String, String> metadataProperties) {
        AnalyzerComponentBuilder<A> analyzerJobBuilder = new AnalyzerComponentBuilder<A>(this, descriptor);
        this.initializeComponentBuilder(analyzerJobBuilder, configuredProperties, requirement, metadataProperties);
        return this.addAnalyzer(analyzerJobBuilder);
    }

    public <A extends Analyzer<?>> AnalyzerComponentBuilder<A> addAnalyzer(AnalyzerComponentBuilder<A> analyzerJobBuilder) {
        this._analyzerComponentBuilders.add(analyzerJobBuilder);
        if (analyzerJobBuilder.getComponentRequirement() == null) {
            analyzerJobBuilder.setComponentRequirement(this._defaultRequirement);
        }
        ArrayList<AnalyzerChangeListener> listeners = new ArrayList<AnalyzerChangeListener>(this._analyzerChangeListeners);
        for (AnalyzerChangeListener listener : listeners) {
            listener.onAdd(analyzerJobBuilder);
        }
        return analyzerJobBuilder;
    }

    public <A extends Analyzer<?>> AnalyzerComponentBuilder<A> addAnalyzer(Class<A> analyzerClass) {
        DescriptorProvider descriptorProvider = this._configuration.getDescriptorProvider();
        AnalyzerDescriptor<A> descriptor = descriptorProvider.getAnalyzerDescriptorForClass(analyzerClass);
        if (descriptor == null) {
            throw new IllegalArgumentException("No descriptor found for: " + analyzerClass);
        }
        return this.addAnalyzer(descriptor);
    }

    public AnalysisJobBuilder removeAnalyzer(AnalyzerComponentBuilder<?> ajb) {
        boolean removed = this._analyzerComponentBuilders.remove(ajb);
        if (removed) {
            ajb.onRemoved();
        }
        return this;
    }

    public List<InputColumn<?>> getAvailableInputColumns(Class<?> dataType) {
        SourceColumnFinder finder = new SourceColumnFinder();
        finder.addSources(this);
        return finder.findInputColumns(dataType);
    }

    public boolean isConfigured(boolean throwException) throws IllegalStateException, UnconfiguredConfiguredPropertyException {
        if (this._datastoreConnection == null) {
            if (throwException) {
                throw new IllegalStateException("No Datastore or DatastoreConnection set");
            }
            return false;
        }
        if (this._sourceColumns.isEmpty()) {
            if (throwException) {
                throw new IllegalStateException("No source columns in job");
            }
            return false;
        }
        if (this._analyzerComponentBuilders.isEmpty()) {
            if (throwException) {
                throw new IllegalStateException("No Analyzers in job");
            }
            return false;
        }
        for (FilterComponentBuilder<?, ?> filterComponentBuilder : this._filterComponentBuilders) {
            if (filterComponentBuilder.isConfigured(throwException)) continue;
            return false;
        }
        for (TransformerComponentBuilder transformerComponentBuilder : this._transformerComponentBuilders) {
            if (transformerComponentBuilder.isConfigured(throwException)) continue;
            return false;
        }
        for (AnalyzerComponentBuilder analyzerComponentBuilder : this._analyzerComponentBuilders) {
            if (analyzerComponentBuilder.isConfigured(throwException)) continue;
            return false;
        }
        return true;
    }

    public boolean isConfigured() {
        return this.isConfigured(false);
    }

    /*
     * WARNING - void declaration
     */
    public AnalysisJob toAnalysisJob(boolean validate) throws IllegalStateException {
        void var7_20;
        if (validate && !this.isConfigured(true)) {
            throw new IllegalStateException("Analysis job is not correctly configured");
        }
        AnalysisJobImmutabilizer immutabilizer = new AnalysisJobImmutabilizer();
        LinkedList<FilterJob> filterJobs = new LinkedList<FilterJob>();
        for (FilterComponentBuilder<?, ?> filterComponentBuilder : this._filterComponentBuilders) {
            try {
                FilterJob filterJob = filterComponentBuilder.toFilterJob(validate, immutabilizer);
                filterJobs.add(filterJob);
            }
            catch (IllegalStateException illegalStateException) {
                throw new IllegalStateException("Could not create filter job from builder: " + filterComponentBuilder + ", (" + illegalStateException.getMessage() + ")", illegalStateException);
            }
        }
        LinkedList<TransformerJob> transformerJobs = new LinkedList<TransformerJob>();
        for (TransformerComponentBuilder<?> transformerComponentBuilder : this._transformerComponentBuilders) {
            try {
                TransformerJob transformerJob = transformerComponentBuilder.toTransformerJob(validate, immutabilizer);
                transformerJobs.add(transformerJob);
            }
            catch (IllegalStateException illegalStateException) {
                throw new IllegalStateException("Could not create transformer job from builder: " + transformerComponentBuilder + ", (" + illegalStateException.getMessage() + ")", illegalStateException);
            }
        }
        LinkedList<AnalyzerJob> linkedList = new LinkedList<AnalyzerJob>();
        for (AnalyzerComponentBuilder<?> analyzerComponentBuilder : this._analyzerComponentBuilders) {
            try {
                AnalyzerJob[] analyzerJob;
                for (AnalyzerJob job : analyzerJob = analyzerComponentBuilder.toAnalyzerJobs(validate, immutabilizer)) {
                    linkedList.add(job);
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Could not create analyzer job from builder: " + analyzerComponentBuilder + ", (" + e.getMessage() + ")", e);
            }
        }
        Datastore datastore = this.getDatastore();
        if (this._analysisJobMetadata == null) {
            AnalysisJobMetadata analysisJobMetadata = this.createMetadata();
        } else {
            MutableAnalysisJobMetadata mutableAnalysisJobMetadata = this._analysisJobMetadata;
        }
        return new ImmutableAnalysisJob((AnalysisJobMetadata)var7_20, datastore, this._sourceColumns, filterJobs, transformerJobs, linkedList);
    }

    public AnalysisJobMetadata createMetadata() {
        MutableAnalysisJobMetadata mutableAnalysisJobMetadata = this.getAnalysisJobMetadata();
        Datastore datastore = this.getDatastore();
        String datastoreName = datastore == null ? null : datastore.getName();
        List<MetaModelInputColumn> sourceColumns = this.getSourceColumns();
        ArrayList<String> sourceColumnPaths = new ArrayList<String>(sourceColumns.size());
        ArrayList<ColumnType> sourceColumnTypes = new ArrayList<ColumnType>(sourceColumns.size());
        for (MetaModelInputColumn sourceColumn : sourceColumns) {
            Column column = sourceColumn.getPhysicalColumn();
            String path = column.getQualifiedLabel();
            ColumnType type = column.getType();
            sourceColumnPaths.add(path);
            sourceColumnTypes.add(type);
        }
        Map<String, String> properties = mutableAnalysisJobMetadata.getProperties();
        Map<String, String> variables = mutableAnalysisJobMetadata.getVariables();
        String jobName = mutableAnalysisJobMetadata.getJobName();
        String jobVersion = mutableAnalysisJobMetadata.getJobVersion();
        String jobDescription = mutableAnalysisJobMetadata.getJobDescription();
        String author = mutableAnalysisJobMetadata.getAuthor();
        Date createdDate = mutableAnalysisJobMetadata.getCreatedDate();
        Date updatedDate = mutableAnalysisJobMetadata.getUpdatedDate();
        ImmutableAnalysisJobMetadata metadata = new ImmutableAnalysisJobMetadata(jobName, jobVersion, jobDescription, author, createdDate, updatedDate, datastoreName, sourceColumnPaths, sourceColumnTypes, variables, properties);
        return metadata;
    }

    public AnalysisJob toAnalysisJob() throws IllegalStateException {
        return this.toAnalysisJob(true);
    }

    public InputColumn<?> getSourceColumnByName(String name) {
        if (name != null) {
            for (MetaModelInputColumn inputColumn : this._sourceColumns) {
                String qualifiedLabel = inputColumn.getPhysicalColumn().getQualifiedLabel();
                if (!name.equalsIgnoreCase(qualifiedLabel)) continue;
                return inputColumn;
            }
            for (MetaModelInputColumn inputColumn : this._sourceColumns) {
                if (!name.equals(inputColumn.getName())) continue;
                return inputColumn;
            }
            for (MetaModelInputColumn inputColumn : this._sourceColumns) {
                if (!name.equalsIgnoreCase(inputColumn.getName())) continue;
                return inputColumn;
            }
        }
        return null;
    }

    public TransformerComponentBuilder<?> getOriginatingTransformer(InputColumn<?> outputColumn) {
        SourceColumnFinder finder = new SourceColumnFinder();
        finder.addSources(this);
        InputColumnSourceJob source = finder.findInputColumnSource(outputColumn);
        if (source instanceof TransformerComponentBuilder) {
            return (TransformerComponentBuilder)source;
        }
        return null;
    }

    public Table getOriginatingTable(InputColumn<?> inputColumn) {
        SourceColumnFinder finder = new SourceColumnFinder();
        finder.addSources(this);
        return finder.findOriginatingTable(inputColumn);
    }

    public Table getOriginatingTable(ComponentBuilder componentBuilder) {
        InputColumn[] inputColumns = componentBuilder.getInput();
        if (inputColumns.length == 0) {
            return null;
        }
        return this.getOriginatingTable(inputColumns[0]);
    }

    public List<ComponentBuilder> getAvailableUnfilteredBeans(FilterComponentBuilder<?, ?> filterJobBuilder) {
        ArrayList<ComponentBuilder> result = new ArrayList<ComponentBuilder>();
        if (filterJobBuilder.isConfigured()) {
            Table foundTable;
            Table requiredTable = this.getOriginatingTable(filterJobBuilder);
            for (FilterComponentBuilder<?, ?> filterComponentBuilder : this._filterComponentBuilders) {
                if (filterComponentBuilder == filterJobBuilder || filterComponentBuilder.getComponentRequirement() != null) continue;
                foundTable = this.getOriginatingTable(filterComponentBuilder);
                if (requiredTable != null && !requiredTable.equals(foundTable)) continue;
                result.add(filterComponentBuilder);
            }
            for (TransformerComponentBuilder transformerComponentBuilder : this._transformerComponentBuilders) {
                if (transformerComponentBuilder.getComponentRequirement() != null) continue;
                foundTable = this.getOriginatingTable(transformerComponentBuilder);
                if (requiredTable != null && !requiredTable.equals(foundTable)) continue;
                result.add(transformerComponentBuilder);
            }
            for (AnalyzerComponentBuilder analyzerComponentBuilder : this._analyzerComponentBuilders) {
                AnalyzerComponentBuilder rpajb;
                if (!(analyzerComponentBuilder instanceof AnalyzerComponentBuilder) || (rpajb = analyzerComponentBuilder).getComponentRequirement() != null) continue;
                Table foundTable2 = this.getOriginatingTable(rpajb);
                if (requiredTable != null && !requiredTable.equals(foundTable2)) continue;
                result.add(rpajb);
            }
        }
        return result;
    }

    public void setDefaultRequirement(FilterComponentBuilder<?, ?> filterJobBuilder, Enum<?> category) {
        this.setDefaultRequirement(filterJobBuilder.getFilterOutcome(category));
    }

    public void setDefaultRequirement(FilterOutcome defaultRequirement) {
        this.setDefaultRequirement(new SimpleComponentRequirement(defaultRequirement));
    }

    public void setDefaultRequirement(ComponentRequirement defaultRequirement) {
        this._defaultRequirement = defaultRequirement;
        if (defaultRequirement != null) {
            FilterComponentBuilder<?, ?> sourceFilterJobBuilder;
            if (defaultRequirement instanceof SimpleComponentRequirement) {
                FilterOutcome outcome = ((SimpleComponentRequirement)defaultRequirement).getOutcome();
                if (outcome instanceof LazyFilterOutcome) {
                    sourceFilterJobBuilder = ((LazyFilterOutcome)outcome).getFilterJobBuilder();
                } else {
                    logger.warn("Default requirement is not a LazyFilterOutcome. This might cause self-referring requirements.");
                    sourceFilterJobBuilder = null;
                }
            } else {
                logger.warn("Default requirement is not a LazyFilterOutcome. This might cause self-referring requirements.");
                sourceFilterJobBuilder = null;
            }
            SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
            sourceColumnFinder.addSources(this);
            Set<Object> excludedSet = sourceColumnFinder.findAllSourceJobs(defaultRequirement);
            for (AnalyzerComponentBuilder<?> analyzerComponentBuilder : this._analyzerComponentBuilders) {
                AnalyzerComponentBuilder<?> analyzerJobBuilder;
                ComponentRequirement requirement;
                if (!(analyzerComponentBuilder instanceof AnalyzerComponentBuilder) || (requirement = (analyzerJobBuilder = analyzerComponentBuilder).getComponentRequirement()) != null) continue;
                analyzerJobBuilder.setComponentRequirement(defaultRequirement);
            }
            for (TransformerComponentBuilder transformerComponentBuilder : this._transformerComponentBuilders) {
                if (transformerComponentBuilder.getComponentRequirement() != null || excludedSet.contains(transformerComponentBuilder)) continue;
                transformerComponentBuilder.setComponentRequirement(defaultRequirement);
            }
            for (FilterComponentBuilder filterComponentBuilder : this._filterComponentBuilders) {
                if (filterComponentBuilder == sourceFilterJobBuilder || filterComponentBuilder.getComponentRequirement() != null || excludedSet.contains(filterComponentBuilder) || !filterComponentBuilder.validateRequirementCandidate(defaultRequirement)) continue;
                filterComponentBuilder.setComponentRequirement(defaultRequirement);
            }
        }
    }

    public ComponentRequirement getDefaultRequirement() {
        return this._defaultRequirement;
    }

    public List<SourceColumnChangeListener> getSourceColumnListeners() {
        return this._sourceColumnListeners;
    }

    public List<AnalyzerChangeListener> getAnalyzerChangeListeners() {
        return this._analyzerChangeListeners;
    }

    public List<TransformerChangeListener> getTransformerChangeListeners() {
        return this._transformerChangeListeners;
    }

    public List<FilterChangeListener> getFilterChangeListeners() {
        return this._filterChangeListeners;
    }

    public List<Table> getSourceTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        List<MetaModelInputColumn> columns = this.getSourceColumns();
        for (MetaModelInputColumn column : columns) {
            Table table = column.getPhysicalColumn().getTable();
            if (tables.contains(table)) continue;
            tables.add(table);
        }
        return tables;
    }

    public void reset() {
        this.setAnalysisJobMetadata(AnalysisJobMetadata.EMPTY_METADATA);
        this.removeAllSourceColumns();
        this.removeAllFilters();
        this.removeAllTransformers();
        this.removeAllAnalyzers();
    }

    public void removeAllSourceColumns() {
        ArrayList<MetaModelInputColumn> sourceColumns = new ArrayList<MetaModelInputColumn>(this._sourceColumns);
        for (MetaModelInputColumn inputColumn : sourceColumns) {
            this.removeSourceColumn(inputColumn);
        }
        assert (this._sourceColumns.isEmpty());
    }

    public void removeAllAnalyzers() {
        ArrayList analyzers = new ArrayList(this._analyzerComponentBuilders);
        for (AnalyzerComponentBuilder analyzerComponentBuilder : analyzers) {
            this.removeAnalyzer(analyzerComponentBuilder);
        }
        assert (this._analyzerComponentBuilders.isEmpty());
    }

    public void removeAllTransformers() {
        ArrayList transformers = new ArrayList(this._transformerComponentBuilders);
        for (TransformerComponentBuilder transformerComponentBuilder : transformers) {
            this.removeTransformer(transformerComponentBuilder);
        }
        assert (this._transformerComponentBuilders.isEmpty());
    }

    public void removeAllFilters() {
        ArrayList filters = new ArrayList(this._filterComponentBuilders);
        for (FilterComponentBuilder filterComponentBuilder : filters) {
            this.removeFilter(filterComponentBuilder);
        }
        assert (this._filterComponentBuilders.isEmpty());
    }

    public Map<String, String> getMetadataProperties() {
        return this.getAnalysisJobMetadata().getProperties();
    }

    @Override
    public void close() {
        if (this._datastoreConnection != null) {
            this._datastoreConnection.close();
        }
    }

    public AnalysisJobBuilder withoutListeners() {
        MutableAnalysisJobMetadata metadataClone = new MutableAnalysisJobMetadata(this.getAnalysisJobMetadata());
        AnalysisJobBuilder clone = new AnalysisJobBuilder(this._configuration, this._datastore, this._datastoreConnection, metadataClone, this._sourceColumns, this._defaultRequirement, this._transformedColumnIdGenerator, this._transformerComponentBuilders, this._filterComponentBuilders, this._analyzerComponentBuilders);
        return clone;
    }

    public int getComponentCount() {
        return this._filterComponentBuilders.size() + this._transformerComponentBuilders.size() + this._analyzerComponentBuilders.size();
    }

    public Collection<ComponentBuilder> getComponentBuilders() {
        ArrayList<ComponentBuilder> result = new ArrayList<ComponentBuilder>();
        result.addAll(this._filterComponentBuilders);
        result.addAll(this._transformerComponentBuilders);
        result.addAll(this._analyzerComponentBuilders);
        return result;
    }

    public List<InputColumn<?>> getAvailableInputColumns(ComponentBuilder componentBuilder) {
        return this.getAvailableInputColumns(componentBuilder, Object.class);
    }

    public List<InputColumn<?>> getAvailableInputColumns(final ComponentBuilder componentBuilder, Class<?> dataType) {
        List result = this.getAvailableInputColumns(dataType);
        final SourceColumnFinder finder = new SourceColumnFinder();
        finder.addSources(this);
        result = CollectionUtils.filter(result, (Predicate)new Predicate<InputColumn<?>>(){

            public Boolean eval(InputColumn<?> inputColumn) {
                if (inputColumn.isPhysicalColumn()) {
                    return true;
                }
                InputColumnSourceJob origin = finder.findInputColumnSource(inputColumn);
                if (origin == null) {
                    return true;
                }
                if (origin == componentBuilder) {
                    return false;
                }
                Set<Object> sourceComponents = finder.findAllSourceJobs(origin);
                if (sourceComponents.contains(componentBuilder)) {
                    return false;
                }
                return true;
            }
        });
        return result;
    }
}

