/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.builder;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.schema.Column;
import org.datacleaner.api.ExpressionBasedInputColumn;
import org.datacleaner.api.InputColumn;
import org.datacleaner.data.MetaModelInputColumn;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnyComponentRequirement;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.CompoundComponentRequirement;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.HasFilterOutcomes;
import org.datacleaner.job.InputColumnSourceJob;
import org.datacleaner.job.SimpleComponentRequirement;
import org.datacleaner.job.builder.AbstractComponentBuilder;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.FilterComponentBuilder;
import org.datacleaner.util.SourceColumnFinder;

final class AnalysisJobBuilderImportHelper {
    private final AnalysisJobBuilder _builder;

    public AnalysisJobBuilderImportHelper(AnalysisJobBuilder builder) {
        this._builder = builder;
    }

    public void importJob(AnalysisJob job) {
        ComponentJob componentJob;
        this._builder.setDatastore(job.getDatastore());
        List sourceColumns = job.getSourceColumns();
        for (InputColumn inputColumn : sourceColumns) {
            this._builder.addSourceColumn((MetaModelInputColumn)inputColumn);
        }
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(job);
        IdentityHashMap<ComponentJob, Object> componentBuilders = new IdentityHashMap<ComponentJob, Object>();
        this.addComponentBuilders(job.getFilterJobs(), componentBuilders);
        this.addComponentBuilders(job.getTransformerJobs(), componentBuilders);
        this.addComponentBuilders(job.getAnalyzerJobs(), componentBuilders);
        for (Map.Entry entry : componentBuilders.entrySet()) {
            componentJob = (ComponentJob)entry.getKey();
            ComponentRequirement originalRequirement = componentJob.getComponentRequirement();
            ComponentRequirement componentRequirement = this.findImportedRequirement(originalRequirement, componentBuilders);
            AbstractComponentBuilder builder = (AbstractComponentBuilder)entry.getValue();
            builder.setComponentRequirement(componentRequirement);
        }
        for (Map.Entry entry : componentBuilders.entrySet()) {
            componentJob = (ComponentJob)entry.getKey();
            Set inputColumnProperties = componentJob.getDescriptor().getConfiguredPropertiesForInput(true);
            AbstractComponentBuilder builder = (AbstractComponentBuilder)entry.getValue();
            for (ConfiguredPropertyDescriptor inputColumnProperty : inputColumnProperties) {
                Object originalInputColumnValue = componentJob.getConfiguration().getProperty(inputColumnProperty);
                Object newInputColumnValue = this.findImportedInputColumns(originalInputColumnValue, componentBuilders, sourceColumnFinder);
                builder.setConfiguredProperty(inputColumnProperty, newInputColumnValue);
            }
        }
    }

    private Object findImportedInputColumns(Object originalInputColumnValue, Map<ComponentJob, Object> componentBuilders, SourceColumnFinder sourceColumnFinder) {
        if (originalInputColumnValue == null) {
            return null;
        }
        if (originalInputColumnValue instanceof InputColumn) {
            return this.findImportedInputColumn((InputColumn)originalInputColumnValue, componentBuilders, sourceColumnFinder);
        }
        if (originalInputColumnValue.getClass().isArray()) {
            int length = Array.getLength(originalInputColumnValue);
            InputColumn[] value = new InputColumn[length];
            for (int i = 0; i < value.length; ++i) {
                InputColumn element = (InputColumn)Array.get(originalInputColumnValue, i);
                value[i] = this.findImportedInputColumn(element, componentBuilders, sourceColumnFinder);
            }
            return value;
        }
        throw new UnsupportedOperationException("Unknown input column value type: " + originalInputColumnValue);
    }

    private InputColumn<?> findImportedInputColumn(InputColumn<?> originalInputColumn, Map<ComponentJob, Object> componentBuilders, SourceColumnFinder sourceColumnFinder) {
        Object[] candidates;
        if (originalInputColumn.isPhysicalColumn()) {
            Column physicalColumn = originalInputColumn.getPhysicalColumn();
            return this._builder.getSourceColumnByName(physicalColumn.getQualifiedLabel());
        }
        if (originalInputColumn instanceof ExpressionBasedInputColumn) {
            return originalInputColumn;
        }
        InputColumnSourceJob originalSourceJob = sourceColumnFinder.findInputColumnSource(originalInputColumn);
        InputColumnSourceJob newSourceJob = (InputColumnSourceJob)componentBuilders.get(originalSourceJob);
        if (newSourceJob == null) {
            throw new IllegalStateException("Could not find builder corresponding to " + originalSourceJob + " in builder map: " + componentBuilders);
        }
        String originalColumnName = originalInputColumn.getName();
        for (InputColumn inputColumn : candidates = newSourceJob.getOutput()) {
            if (!inputColumn.getName().equals(originalColumnName)) continue;
            return inputColumn;
        }
        throw new IllegalStateException("Could not determine a replacement input column for '" + originalColumnName + "' in output column candidate set: " + Arrays.toString(candidates));
    }

    private ComponentRequirement findImportedRequirement(ComponentRequirement originalRequirement, Map<ComponentJob, Object> componentBuilders) {
        if (originalRequirement == null) {
            return null;
        }
        if (originalRequirement instanceof AnyComponentRequirement) {
            return AnyComponentRequirement.get();
        }
        if (originalRequirement instanceof SimpleComponentRequirement) {
            FilterOutcome originalFilterOutcome = ((SimpleComponentRequirement)originalRequirement).getOutcome();
            FilterOutcome newOutcome = this.findFilterOutcome(originalFilterOutcome, componentBuilders);
            return new SimpleComponentRequirement(newOutcome);
        }
        if (originalRequirement instanceof CompoundComponentRequirement) {
            Set<FilterOutcome> originalOutcomes = ((CompoundComponentRequirement)originalRequirement).getOutcomes();
            HashSet<FilterOutcome> newOutcomes = new HashSet<FilterOutcome>();
            for (FilterOutcome originalOutcome : originalOutcomes) {
                FilterOutcome newOutcome = this.findFilterOutcome(originalOutcome, componentBuilders);
                newOutcomes.add(newOutcome);
            }
            return new CompoundComponentRequirement(newOutcomes);
        }
        throw new UnsupportedOperationException("Unsupported requirement type: " + originalRequirement);
    }

    private FilterOutcome findFilterOutcome(FilterOutcome originalFilterOutcome, Map<ComponentJob, Object> componentBuilders) {
        HasFilterOutcomes source = originalFilterOutcome.getSource();
        Object builder = componentBuilders.get(source);
        if (builder == null) {
            throw new IllegalStateException("Could not find builder corresponding to " + source + " in builder map: " + componentBuilders);
        }
        Enum category = originalFilterOutcome.getCategory();
        FilterComponentBuilder filterJobBuilder = (FilterComponentBuilder)builder;
        FilterOutcome newOutcome = filterJobBuilder.getFilterOutcome(category);
        return newOutcome;
    }

    private void addComponentBuilders(Collection<? extends ComponentJob> componentJobs, Map<ComponentJob, Object> componentBuilders) {
        for (ComponentJob componentJob : componentJobs) {
            Object builder = this._builder.addComponent(componentJob);
            componentBuilders.put(componentJob, builder);
        }
    }
}

