/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.builder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.ColumnProperty;
import org.datacleaner.api.InputColumn;
import org.datacleaner.descriptors.AnalyzerDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.AnalysisJobImmutabilizer;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentConfigurationException;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.ImmutableAnalyzerJob;
import org.datacleaner.job.ImmutableComponentConfiguration;
import org.datacleaner.job.builder.AbstractComponentBuilder;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.AnalyzerChangeListener;
import org.datacleaner.util.LabelUtils;
import org.datacleaner.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalyzerComponentBuilder<A extends Analyzer<?>>
extends AbstractComponentBuilder<AnalyzerDescriptor<A>, A, AnalyzerComponentBuilder<A>> {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisJobBuilder.class);
    private final boolean _multipleJobsSupported;
    private final List<InputColumn<?>> _inputColumns;
    private final ConfiguredPropertyDescriptor _inputProperty;
    private final List<AnalyzerChangeListener> _localChangeListeners;

    public AnalyzerComponentBuilder(AnalysisJobBuilder analysisJobBuilder, AnalyzerDescriptor<A> descriptor) {
        super(analysisJobBuilder, descriptor, AnalyzerComponentBuilder.class);
        Set inputProperties = descriptor.getConfiguredPropertiesForInput(false);
        if (inputProperties.size() == 1) {
            this._inputProperty = (ConfiguredPropertyDescriptor)inputProperties.iterator().next();
            ColumnProperty columnProperty = (ColumnProperty)this._inputProperty.getAnnotation(ColumnProperty.class);
            this._multipleJobsSupported = columnProperty != null && columnProperty.escalateToMultipleJobs();
            this._inputColumns = new ArrayList();
        } else {
            this._multipleJobsSupported = false;
            this._inputColumns = null;
            this._inputProperty = null;
        }
        this._localChangeListeners = new ArrayList<AnalyzerChangeListener>(0);
    }

    private List<AnalyzerChangeListener> getAllListeners() {
        List<AnalyzerChangeListener> globalChangeListeners = this.getAnalysisJobBuilder().getAnalyzerChangeListeners();
        ArrayList<AnalyzerChangeListener> list = new ArrayList<AnalyzerChangeListener>(globalChangeListeners.size() + this._localChangeListeners.size());
        list.addAll(globalChangeListeners);
        list.addAll(this._localChangeListeners);
        return list;
    }

    public boolean isMultipleJobsDeterminedBy(ConfiguredPropertyDescriptor propertyDescriptor) {
        return this._multipleJobsSupported && propertyDescriptor.isInputColumn() && propertyDescriptor.isRequired();
    }

    public AnalyzerJob toAnalyzerJob() throws IllegalStateException {
        return this.toAnalyzerJob(true);
    }

    public AnalyzerJob toAnalyzerJob(boolean validate) throws IllegalStateException {
        AnalyzerJob[] analyzerJobs = this.toAnalyzerJobs();
        if (analyzerJobs == null || analyzerJobs.length == 0) {
            return null;
        }
        if (validate && analyzerJobs.length > 1) {
            throw new IllegalStateException("This builder generates " + analyzerJobs.length + " jobs, but a single job was requested");
        }
        return analyzerJobs[0];
    }

    public AnalyzerJob[] toAnalyzerJobs() throws IllegalStateException {
        return this.toAnalyzerJobs(true);
    }

    public AnalyzerJob[] toAnalyzerJobs(AnalysisJobImmutabilizer immutabilizer) throws IllegalStateException {
        return this.toAnalyzerJobs(true, immutabilizer);
    }

    public AnalyzerJob[] toAnalyzerJobs(boolean validate) throws IllegalStateException {
        return this.toAnalyzerJobs(validate, new AnalysisJobImmutabilizer());
    }

    public AnalyzerJob[] toAnalyzerJobs(boolean validate, AnalysisJobImmutabilizer immutabilizer) throws IllegalStateException {
        Map<ConfiguredPropertyDescriptor, Object> configuredProperties = this.getConfiguredProperties();
        ComponentRequirement componentRequirement = immutabilizer.load(this.getComponentRequirement());
        if (!this._multipleJobsSupported) {
            ImmutableAnalyzerJob job = new ImmutableAnalyzerJob(this.getName(), (AnalyzerDescriptor)this.getDescriptor(), new ImmutableComponentConfiguration(configuredProperties), componentRequirement, this.getMetadataProperties());
            return new AnalyzerJob[]{job};
        }
        if (validate && this._inputColumns.isEmpty()) {
            throw new IllegalStateException("No input column configured");
        }
        ArrayList tableLessColumns = new ArrayList();
        LinkedHashMap originatingTables = new LinkedHashMap();
        for (InputColumn<?> inputColumn : this._inputColumns) {
            Table table = this.getAnalysisJobBuilder().getOriginatingTable(inputColumn);
            if (table == null) {
                tableLessColumns.add(inputColumn);
                continue;
            }
            ArrayList list = (ArrayList)originatingTables.get(table);
            if (list == null) {
                list = new ArrayList();
            }
            list.add(inputColumn);
            originatingTables.put(table, list);
        }
        if (validate && originatingTables.isEmpty()) {
            List<Table> sourceTables = this.getAnalysisJobBuilder().getSourceTables();
            if (sourceTables.size() == 1) {
                logger.info("Only a single source table is available, so the source of analyzer '{}' is inferred", (Object)this);
                Table table = sourceTables.get(0);
                originatingTables.put(table, new ArrayList());
            } else {
                throw new IllegalStateException("Could not determine source for analyzer '" + this + "'");
            }
        }
        if (originatingTables.size() == 1 && this._inputProperty.isArray()) {
            Object job = new ImmutableAnalyzerJob(this.getName(), (AnalyzerDescriptor)this.getDescriptor(), new ImmutableComponentConfiguration(configuredProperties), componentRequirement, this.getMetadataProperties());
            return new AnalyzerJob[]{job};
        }
        for (Map.Entry entry : originatingTables.entrySet()) {
            ((List)entry.getValue()).addAll(tableLessColumns);
        }
        ArrayList<AnalyzerJob> jobs = new ArrayList<AnalyzerJob>();
        Set entrySet = originatingTables.entrySet();
        for (Map.Entry entry : entrySet) {
            List columns = (List)entry.getValue();
            if (this._inputProperty.isArray()) {
                jobs.add(this.createPartitionedJob(columns.toArray(new InputColumn[columns.size()]), configuredProperties));
                continue;
            }
            for (InputColumn column : columns) {
                jobs.add(this.createPartitionedJob(column, configuredProperties));
            }
        }
        if (validate && !this.isConfigured()) {
            throw new IllegalStateException("Row processing Analyzer job is not correctly configured");
        }
        return jobs.toArray(new AnalyzerJob[jobs.size()]);
    }

    @Override
    public AnalyzerComponentBuilder<A> addInputColumn(InputColumn<?> inputColumn, ConfiguredPropertyDescriptor propertyDescriptor) {
        assert (propertyDescriptor.isInputColumn());
        if (inputColumn == null) {
            throw new IllegalArgumentException("InputColumn cannot be null");
        }
        if (this.isMultipleJobsDeterminedBy(propertyDescriptor)) {
            this._inputColumns.add(inputColumn);
            return this;
        }
        return (AnalyzerComponentBuilder)super.addInputColumn(inputColumn, propertyDescriptor);
    }

    @Override
    public boolean isConfigured(ConfiguredPropertyDescriptor configuredProperty, boolean throwException) {
        if (this._multipleJobsSupported && configuredProperty == this._inputProperty) {
            if (this._inputColumns.isEmpty()) {
                Object propertyValue = super.getConfiguredProperty(configuredProperty);
                if (propertyValue != null && propertyValue.getClass().isArray() && Array.getLength(propertyValue) > 0) {
                    this.setConfiguredProperty(configuredProperty, propertyValue);
                    return this.isConfigured(configuredProperty, throwException);
                }
                if (throwException) {
                    throw new ComponentConfigurationException("No input columns configured for " + LabelUtils.getLabel(this));
                }
                return false;
            }
            return true;
        }
        return super.isConfigured(configuredProperty, throwException);
    }

    private AnalyzerJob createPartitionedJob(Object columnValue, Map<ConfiguredPropertyDescriptor, Object> configuredProperties) {
        HashMap<ConfiguredPropertyDescriptor, Object> jobProperties = new HashMap<ConfiguredPropertyDescriptor, Object>(configuredProperties);
        jobProperties.put(this._inputProperty, columnValue);
        ComponentRequirement componentRequirement = new AnalysisJobImmutabilizer().load(this.getComponentRequirement());
        ImmutableAnalyzerJob job = new ImmutableAnalyzerJob(this.getName(), (AnalyzerDescriptor)this.getDescriptor(), new ImmutableComponentConfiguration(jobProperties), componentRequirement, this.getMetadataProperties());
        return job;
    }

    public String toString() {
        return "AnalyzerComponentBuilder[analyzer=" + ((AnalyzerDescriptor)this.getDescriptor()).getDisplayName() + ",inputColumns=" + this.getInputColumns() + "]";
    }

    @Override
    public AnalyzerComponentBuilder<A> setConfiguredProperty(ConfiguredPropertyDescriptor configuredProperty, Object value) {
        if (this.isMultipleJobsDeterminedBy(configuredProperty)) {
            Object dummyValue;
            this._inputColumns.clear();
            if (ReflectionUtils.isArray(value)) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    InputColumn inputColumn = (InputColumn)Array.get(value, i);
                    this._inputColumns.add(inputColumn);
                }
                dummyValue = this._inputColumns.isEmpty() ? null : this._inputColumns.iterator().next();
            } else {
                InputColumn<?> col = (InputColumn<?>)value;
                this._inputColumns.add(col);
                dummyValue = col;
            }
            if (configuredProperty.isArray()) {
                InputColumn[] inputColumsArray = dummyValue == null ? new InputColumn[]{} : new InputColumn[]{dummyValue};
                return (AnalyzerComponentBuilder)super.setConfiguredProperty(configuredProperty, (Object)inputColumsArray);
            }
            return (AnalyzerComponentBuilder)super.setConfiguredProperty(configuredProperty, dummyValue);
        }
        return (AnalyzerComponentBuilder)super.setConfiguredProperty(configuredProperty, value);
    }

    @Override
    public Object getConfiguredProperty(ConfiguredPropertyDescriptor propertyDescriptor) {
        if (this.isMultipleJobsDeterminedBy(propertyDescriptor)) {
            return this._inputColumns.toArray(new InputColumn[this._inputColumns.size()]);
        }
        return super.getConfiguredProperty(propertyDescriptor);
    }

    @Override
    public void onConfigurationChanged() {
        super.onConfigurationChanged();
        List<AnalyzerChangeListener> listeners = this.getAllListeners();
        for (AnalyzerChangeListener listener : listeners) {
            listener.onConfigurationChanged(this);
        }
    }

    @Override
    public void onRequirementChanged() {
        super.onRequirementChanged();
        List<AnalyzerChangeListener> listeners = this.getAllListeners();
        for (AnalyzerChangeListener listener : listeners) {
            listener.onRequirementChanged(this);
        }
    }

    public boolean isMultipleJobsSupported() {
        return this._multipleJobsSupported;
    }

    @Override
    protected void onRemovedInternal() {
        List<AnalyzerChangeListener> listeners = this.getAllListeners();
        for (AnalyzerChangeListener listener : listeners) {
            listener.onRemove(this);
        }
    }

    public void addChangeListener(AnalyzerChangeListener listener) {
        this._localChangeListeners.add(listener);
    }

    public boolean removeChangeListener(AnalyzerChangeListener listener) {
        return this._localChangeListeners.remove(listener);
    }
}

