/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import org.datacleaner.api.Filter;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.job.AnalysisJobImmutabilizer;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterJob;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.HasFilterOutcomes;
import org.datacleaner.job.ImmutableComponentConfiguration;
import org.datacleaner.job.ImmutableFilterJob;
import org.datacleaner.job.builder.AbstractComponentBuilder;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.FilterChangeListener;
import org.datacleaner.job.builder.LazyFilterOutcome;

public final class FilterComponentBuilder<F extends Filter<C>, C extends Enum<C>>
extends AbstractComponentBuilder<FilterDescriptor<F, C>, F, FilterComponentBuilder<F, C>>
implements HasFilterOutcomes {
    private FilterJob _cachedJob;
    private EnumMap<C, FilterOutcome> _outcomes;
    private final List<FilterChangeListener> _localChangeListeners;

    public FilterComponentBuilder(AnalysisJobBuilder analysisJobBuilder, FilterDescriptor<F, C> descriptor) {
        super(analysisJobBuilder, descriptor, FilterComponentBuilder.class);
        this._outcomes = new EnumMap(descriptor.getOutcomeCategoryEnum());
        EnumSet categories = descriptor.getOutcomeCategories();
        for (Enum category : categories) {
            this._outcomes.put((C)category, new LazyFilterOutcome(this, category));
        }
        this._localChangeListeners = new ArrayList<FilterChangeListener>(0);
    }

    public FilterJob toFilterJob() {
        return this.toFilterJob(true);
    }

    public FilterJob toFilterJob(AnalysisJobImmutabilizer immutabilizer) {
        return this.toFilterJob(true, immutabilizer);
    }

    public FilterJob toFilterJob(boolean validate) {
        return this.toFilterJob(validate, new AnalysisJobImmutabilizer());
    }

    public FilterJob toFilterJob(boolean validate, AnalysisJobImmutabilizer immutabilizer) {
        if (validate && !this.isConfigured(true)) {
            throw new IllegalStateException("Filter job is not correctly configured");
        }
        ComponentRequirement componentRequirement = immutabilizer.load(this.getComponentRequirement());
        if (this._cachedJob == null) {
            this._cachedJob = new ImmutableFilterJob(this.getName(), (FilterDescriptor)this.getDescriptor(), new ImmutableComponentConfiguration(this.getConfiguredProperties()), componentRequirement, this.getMetadataProperties());
        } else {
            ImmutableFilterJob newFilterJob = new ImmutableFilterJob(this.getName(), (FilterDescriptor)this.getDescriptor(), new ImmutableComponentConfiguration(this.getConfiguredProperties()), componentRequirement, this.getMetadataProperties());
            if (!newFilterJob.equals(this._cachedJob)) {
                this._cachedJob = newFilterJob;
            }
        }
        return this._cachedJob;
    }

    private List<FilterChangeListener> getAllListeners() {
        List<FilterChangeListener> globalChangeListeners = this.getAnalysisJobBuilder().getFilterChangeListeners();
        ArrayList<FilterChangeListener> list = new ArrayList<FilterChangeListener>(globalChangeListeners.size() + this._localChangeListeners.size());
        list.addAll(globalChangeListeners);
        list.addAll(this._localChangeListeners);
        return list;
    }

    public String toString() {
        return "FilterComponentBuilder[filter=" + ((FilterDescriptor)this.getDescriptor()).getDisplayName() + ",inputColumns=" + this.getInputColumns() + "]";
    }

    @Override
    public void onConfigurationChanged() {
        super.onConfigurationChanged();
        List<FilterChangeListener> listeners = this.getAllListeners();
        for (FilterChangeListener listener : listeners) {
            listener.onConfigurationChanged(this);
        }
    }

    @Override
    public void onRequirementChanged() {
        super.onRequirementChanged();
        List<FilterChangeListener> listeners = this.getAllListeners();
        for (FilterChangeListener listener : listeners) {
            listener.onRequirementChanged(this);
        }
    }

    public Collection<FilterOutcome> getFilterOutcomes() {
        Collection<FilterOutcome> outcomes = this._outcomes.values();
        return outcomes;
    }

    @Deprecated
    public FilterOutcome getOutcome(C category) {
        return this.getFilterOutcome(category);
    }

    public FilterOutcome getFilterOutcome(C category) {
        FilterOutcome outcome = this._outcomes.get(category);
        if (outcome == null) {
            throw new IllegalArgumentException(category + " is not a valid category for " + this);
        }
        return outcome;
    }

    @Deprecated
    public FilterOutcome getOutcome(Object category) {
        return this.getFilterOutcome(category);
    }

    public FilterOutcome getFilterOutcome(Object category) {
        FilterOutcome outcome;
        if (category instanceof String) {
            EnumSet categories = ((FilterDescriptor)this.getDescriptor()).getOutcomeCategories();
            for (Enum c : categories) {
                if (!c.name().equals(category)) continue;
                category = c;
                break;
            }
        }
        if ((outcome = this._outcomes.get(category)) == null) {
            throw new IllegalArgumentException(category + " is not a valid category for " + this);
        }
        return outcome;
    }

    @Override
    protected void onRemovedInternal() {
        List<FilterChangeListener> listeners = this.getAllListeners();
        for (FilterChangeListener listener : listeners) {
            listener.onRemove(this);
        }
    }

    public void addChangeListener(FilterChangeListener listener) {
        this._localChangeListeners.add(listener);
    }

    public boolean removeChangeListener(FilterChangeListener listener) {
        return this._localChangeListeners.remove(listener);
    }
}

