/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.concurrent;

import java.util.Collection;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.concurrent.TaskRunnable;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.job.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ForkTaskListener
implements TaskListener {
    private static final Logger logger = LoggerFactory.getLogger(ForkTaskListener.class);
    private final TaskRunner _taskRunner;
    private final Collection<TaskRunnable> _tasks;
    private final String _whatAreYouWaitingFor;

    public ForkTaskListener(String whatAreYouWaitingFor, TaskRunner taskRunner, Collection<TaskRunnable> tasksToSchedule) {
        this._whatAreYouWaitingFor = whatAreYouWaitingFor;
        this._taskRunner = taskRunner;
        this._tasks = tasksToSchedule;
    }

    @Override
    public void onComplete(Task task) {
        logger.info("onComplete({})", (Object)this._whatAreYouWaitingFor);
        int index = 1;
        for (TaskRunnable tr : this._tasks) {
            logger.info("Scheduling task {} out of {}: {}", new Object[]{index, this._tasks.size(), tr});
            this._taskRunner.run(tr);
            ++index;
        }
    }

    @Override
    public void onBegin(Task task) {
    }

    @Override
    public void onError(Task task, Throwable throwable) {
        for (TaskRunnable tr : this._tasks) {
            TaskListener listener = tr.getListener();
            if (listener == null) {
                logger.warn("TaskListener for {} was null", (Object)tr);
                continue;
            }
            listener.onError(task, throwable);
        }
    }
}

