/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.concurrent;

import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.datacleaner.job.concurrent.ForkTaskListener;
import org.datacleaner.job.concurrent.StatusAwareTaskListener;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobCompletionTaskListener
implements StatusAwareTaskListener {
    private static final Logger logger = LoggerFactory.getLogger(ForkTaskListener.class);
    private final CountDownLatch _countDownLatch;
    private final AnalysisListener _analysisListener;
    private final AnalysisJobMetrics _analysisJobMetrics;
    private Date _completionTime;

    public JobCompletionTaskListener(AnalysisJobMetrics analysisJobMetrics, AnalysisListener analysisListener, int callablesToWaitFor) {
        this._analysisJobMetrics = analysisJobMetrics;
        this._analysisListener = analysisListener;
        this._countDownLatch = new CountDownLatch(callablesToWaitFor);
    }

    @Override
    public void await() throws InterruptedException {
        this._countDownLatch.await();
    }

    @Override
    public boolean isDone() {
        return this._countDownLatch.getCount() == 0L;
    }

    @Override
    public void await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this._countDownLatch.await(timeout, timeUnit);
    }

    @Override
    public void onBegin(Task task) {
    }

    @Override
    public void onComplete(Task task) {
        logger.debug("onComplete(...)");
        this._countDownLatch.countDown();
        if (this._countDownLatch.getCount() == 0L) {
            this._completionTime = new Date();
            this._analysisListener.jobSuccess(this._analysisJobMetrics.getAnalysisJob(), this._analysisJobMetrics);
        }
    }

    @Override
    public void onError(Task task, Throwable throwable) {
        logger.debug("onError(...)");
        this._analysisListener.errorUknown(this._analysisJobMetrics.getAnalysisJob(), throwable);
        this._countDownLatch.countDown();
    }

    @Override
    public Date getCompletionTime() {
        return this._completionTime;
    }
}

