/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.concurrent;

import org.datacleaner.api.OutputRowCollector;

public class ThreadLocalOutputRowCollector
implements OutputRowCollector {
    private final ThreadLocal<Listener> _listener = new ThreadLocal();

    public void setListener(Listener listener) {
        this._listener.set(listener);
    }

    public void removeListener() {
        this._listener.remove();
    }

    public void putValues(Object ... values) {
        Listener listener = this._listener.get();
        if (listener == null) {
            throw new IllegalStateException("No thread local listener registered!");
        }
        listener.onValues(values);
    }

    public static interface Listener {
        public void onValues(Object[] var1);
    }
}

