/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.HashSet;
import java.util.Set;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnyComponentRequirement;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterOutcomes;
import org.datacleaner.job.HasComponentRequirement;
import org.datacleaner.job.InputColumnSinkJob;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.RowProcessingChain;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.util.SourceColumnFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRowProcessingConsumer
implements RowProcessingConsumer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRowProcessingConsumer.class);
    private final AnalysisJob _analysisJob;
    private final AnalysisListener _analysisListener;
    private final HasComponentRequirement _hasComponentRequirement;
    private final Set<HasComponentRequirement> _sourceJobsOfInputColumns;
    private final boolean _alwaysSatisfiedForConsume;

    protected AbstractRowProcessingConsumer(RowProcessingPublishers publishers, HasComponentRequirement outcomeSinkJob, InputColumnSinkJob inputColumnSinkJob) {
        this(publishers.getAnalysisJob(), publishers.getAnalysisListener(), outcomeSinkJob, inputColumnSinkJob, publishers.getSourceColumnFinder());
    }

    protected AbstractRowProcessingConsumer(AnalysisJob analysisJob, AnalysisListener analysisListener, HasComponentRequirement outcomeSinkJob, InputColumnSinkJob inputColumnSinkJob, SourceColumnFinder sourceColumnFinder) {
        this(analysisJob, analysisListener, outcomeSinkJob, AbstractRowProcessingConsumer.buildSourceJobsOfInputColumns(inputColumnSinkJob, sourceColumnFinder));
    }

    protected AbstractRowProcessingConsumer(AnalysisJob analysisJob, AnalysisListener analysisListener, HasComponentRequirement outcomeSinkJob, Set<HasComponentRequirement> sourceJobsOfInputColumns) {
        this._analysisJob = analysisJob;
        this._analysisListener = analysisListener;
        this._hasComponentRequirement = outcomeSinkJob;
        this._sourceJobsOfInputColumns = sourceJobsOfInputColumns;
        this._alwaysSatisfiedForConsume = this.isAlwaysSatisfiedForConsume();
    }

    private boolean isAlwaysSatisfiedForConsume() {
        if (this._sourceJobsOfInputColumns.isEmpty()) {
            return true;
        }
        return this.isAlwaysSatisfiedRequirement();
    }

    private boolean isAlwaysSatisfiedRequirement() {
        ComponentRequirement componentRequirement = this._hasComponentRequirement.getComponentRequirement();
        if (componentRequirement == null) {
            return false;
        }
        return componentRequirement instanceof AnyComponentRequirement;
    }

    private static Set<HasComponentRequirement> buildSourceJobsOfInputColumns(InputColumnSinkJob inputColumnSinkJob, SourceColumnFinder sourceColumnFinder) {
        HashSet<HasComponentRequirement> result = new HashSet<HasComponentRequirement>();
        Set<Object> sourceJobsOfInputColumns = sourceColumnFinder.findAllSourceJobs(inputColumnSinkJob);
        for (Object sourceJob : sourceJobsOfInputColumns) {
            HasComponentRequirement sourceOutcomeSinkJob;
            ComponentRequirement componentRequirement;
            if (!(sourceJob instanceof HasComponentRequirement) || (componentRequirement = (sourceOutcomeSinkJob = (HasComponentRequirement)sourceJob).getComponentRequirement()) == null) continue;
            result.add(sourceOutcomeSinkJob);
        }
        return result;
    }

    @Override
    public final boolean satisfiedForConsume(FilterOutcomes outcomes, InputRow row) {
        boolean satisfiedOutcomesForConsume = this.satisfiedOutcomesForConsume(this._hasComponentRequirement, row, outcomes);
        if (!satisfiedOutcomesForConsume) {
            return false;
        }
        boolean satisfiedInputsForConsume = this.satisfiedInputsForConsume(row, outcomes);
        return satisfiedInputsForConsume;
    }

    @Override
    public InputColumn<?>[] getOutputColumns() {
        return new InputColumn[0];
    }

    @Override
    public final void consume(InputRow row, int distinctCount, FilterOutcomes outcomes, RowProcessingChain chain) {
        try {
            this.consumeInternal(row, distinctCount, outcomes, chain);
        }
        catch (RuntimeException e) {
            ComponentJob componentJob = this.getComponentJob();
            if (this._analysisListener == null) {
                logger.error("Error occurred in component '" + componentJob + "' and no AnalysisListener is available", (Throwable)e);
                throw e;
            }
            this._analysisListener.errorInComponent(this._analysisJob, componentJob, row, e);
        }
    }

    protected abstract void consumeInternal(InputRow var1, int var2, FilterOutcomes var3, RowProcessingChain var4);

    private boolean satisfiedInputsForConsume(InputRow row, FilterOutcomes outcomes) {
        if (this._alwaysSatisfiedForConsume) {
            return this._alwaysSatisfiedForConsume;
        }
        ComponentRequirement componentRequirement = this._hasComponentRequirement.getComponentRequirement();
        if (componentRequirement == null) {
            for (HasComponentRequirement sourceJobsOfInputColumn : this._sourceJobsOfInputColumns) {
                HasComponentRequirement hasComponentRequirement;
                boolean satisfiedOutcomesForConsume;
                if (!(sourceJobsOfInputColumn instanceof HasComponentRequirement) || !(satisfiedOutcomesForConsume = this.satisfiedOutcomesForConsume(hasComponentRequirement = sourceJobsOfInputColumn, row, outcomes))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean satisfiedOutcomesForConsume(HasComponentRequirement component, InputRow row, FilterOutcomes outcomes) {
        boolean isSatisfiedOutcomes = false;
        ComponentRequirement componentRequirement = component.getComponentRequirement();
        isSatisfiedOutcomes = componentRequirement == null ? true : componentRequirement.isSatisfied(row, outcomes);
        return isSatisfiedOutcomes;
    }

    @Override
    public final boolean satisfiedForFlowOrdering(FilterOutcomes outcomes) {
        if (this.isAlwaysSatisfiedRequirement()) {
            return true;
        }
        ComponentRequirement componentRequirement = this._hasComponentRequirement.getComponentRequirement();
        if (componentRequirement == null) {
            return true;
        }
        return componentRequirement.isSatisfied(null, outcomes);
    }
}

