/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.Collections;
import java.util.List;

public class AnalysisJobFailedException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final List<Throwable> _errors;

    public AnalysisJobFailedException(List<Throwable> errors) {
        this._errors = errors == null ? Collections.emptyList() : errors;
    }

    @Override
    public String getMessage() {
        if (this._errors.isEmpty()) {
            return "The analysis ended with an error state, but no exceptions where reported. Please inspect the logs.";
        }
        StringBuilder sb = new StringBuilder();
        for (Throwable throwable : this._errors) {
            if (sb.length() == 0) {
                sb.append("The analysis ended with " + this._errors.size() + " errors: [");
            } else {
                sb.append(",");
            }
            String className = throwable.getClass().getSimpleName();
            sb.append(className);
            sb.append(": ");
            String message = throwable.getMessage();
            sb.append(message);
        }
        sb.append("]");
        return sb.toString();
    }

    public List<Throwable> getErrors() {
        return this._errors;
    }

    @Override
    public Throwable getCause() {
        if (this._errors.isEmpty()) {
            return null;
        }
        return this._errors.get(0);
    }
}

