/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import org.apache.metamodel.schema.Table;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.AnalyzerMetrics;
import org.datacleaner.job.runner.AnalyzerMetricsImpl;
import org.datacleaner.job.runner.RowProcessingMetrics;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.job.runner.RowProcessingPublishers;

final class AnalysisJobMetricsImpl
implements AnalysisJobMetrics {
    private final AnalysisJob _job;
    private final RowProcessingPublishers _publishers;

    public AnalysisJobMetricsImpl(AnalysisJob job, RowProcessingPublishers publishers) {
        this._job = job;
        this._publishers = publishers;
    }

    @Override
    public AnalysisJob getAnalysisJob() {
        return this._job;
    }

    @Override
    public AnalyzerMetrics getAnalyzerMetrics(AnalyzerJob analyzerJob) {
        Table table = this.getRowProcessingTable(analyzerJob);
        RowProcessingMetrics rowProcessingMetrics = this.getRowProcessingMetrics(table);
        return new AnalyzerMetricsImpl(rowProcessingMetrics, analyzerJob);
    }

    @Override
    public Table[] getRowProcessingTables() {
        return this._publishers.getTables();
    }

    @Override
    public RowProcessingMetrics getRowProcessingMetrics(Table table) {
        RowProcessingPublisher publisher = this._publishers.getRowProcessingPublisher(table);
        if (publisher == null) {
            return null;
        }
        return publisher.getRowProcessingMetrics();
    }

    @Override
    public Table getRowProcessingTable(AnalyzerJob analyzerJob) {
        Table[] tables = this._publishers.getTables((ComponentJob)analyzerJob);
        if (tables == null || tables.length == 0) {
            return null;
        }
        return tables[0];
    }
}

