/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.concurrent.LinkedBlockingQueue;
import org.datacleaner.configuration.AnalyzerBeansConfiguration;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.job.runner.AnalysisRunner;
import org.datacleaner.job.runner.AnalysisRunnerJobDelegate;
import org.datacleaner.job.runner.CompositeAnalysisListener;
import org.datacleaner.job.runner.DebugLoggingAnalysisListener;
import org.datacleaner.job.runner.ErrorAwareAnalysisListener;
import org.datacleaner.job.runner.ErrorAwareTaskRunnerWrapper;
import org.datacleaner.job.runner.InfoLoggingAnalysisListener;
import org.datacleaner.job.runner.JobAndResult;

public class AnalysisRunnerImpl
implements AnalysisRunner {
    private final AnalyzerBeansConfiguration _configuration;
    private final AnalysisListener[] _sharedAnalysisListeners;

    public AnalysisRunnerImpl(AnalyzerBeansConfiguration configuration) {
        this(configuration, new AnalysisListener[0]);
    }

    public AnalysisRunnerImpl(AnalyzerBeansConfiguration configuration, AnalysisListener ... sharedAnalysisListeners) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        this._configuration = configuration;
        this._sharedAnalysisListeners = sharedAnalysisListeners;
    }

    @Override
    public AnalysisResultFuture run(AnalysisJob job) {
        LinkedBlockingQueue<JobAndResult> resultQueue = new LinkedBlockingQueue<JobAndResult>();
        ErrorAwareAnalysisListener errorListener = new ErrorAwareAnalysisListener();
        CompositeAnalysisListener analysisListener = new CompositeAnalysisListener(errorListener, this._sharedAnalysisListeners);
        if (DebugLoggingAnalysisListener.isEnabled()) {
            analysisListener.addDelegate(new DebugLoggingAnalysisListener());
        } else if (InfoLoggingAnalysisListener.isEnabled()) {
            analysisListener.addDelegate(new InfoLoggingAnalysisListener());
        }
        ErrorAwareTaskRunnerWrapper taskRunner = new ErrorAwareTaskRunnerWrapper(errorListener, this._configuration.getTaskRunner());
        boolean includedNonDistributed = this.isNonDistributedTasksIncluded();
        AnalysisRunnerJobDelegate delegate = new AnalysisRunnerJobDelegate(job, this._configuration, taskRunner, analysisListener, resultQueue, errorListener, includedNonDistributed);
        return delegate.run();
    }

    protected boolean isNonDistributedTasksIncluded() {
        return true;
    }
}

