/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.InputColumn;
import org.datacleaner.configuration.AnalyzerBeansConfiguration;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.FilterJob;
import org.datacleaner.job.TransformerJob;
import org.datacleaner.job.concurrent.ForkTaskListener;
import org.datacleaner.job.concurrent.JobCompletionTaskListener;
import org.datacleaner.job.concurrent.JoinTaskListener;
import org.datacleaner.job.concurrent.TaskRunnable;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.job.runner.AnalysisResultFutureImpl;
import org.datacleaner.job.runner.ErrorAware;
import org.datacleaner.job.runner.JobAndResult;
import org.datacleaner.job.runner.ReferenceDataActivationManager;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.job.tasks.CloseReferenceDataTaskListener;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.util.SourceColumnFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AnalysisRunnerJobDelegate {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisRunnerJobDelegate.class);
    private final AnalysisJob _job;
    private final AnalyzerBeansConfiguration _configuration;
    private final TaskRunner _taskRunner;
    private final AnalysisListener _analysisListener;
    private final Queue<JobAndResult> _resultQueue;
    private final ErrorAware _errorAware;
    private final Collection<AnalyzerJob> _analyzerJobs;
    private final Collection<TransformerJob> _transformerJobs;
    private final Collection<FilterJob> _filterJobs;
    private final SourceColumnFinder _sourceColumnFinder;
    private final boolean _includeNonDistributedTasks;

    public AnalysisRunnerJobDelegate(AnalysisJob job, AnalyzerBeansConfiguration configuration, TaskRunner taskRunner, AnalysisListener analysisListener, Queue<JobAndResult> resultQueue, ErrorAware errorAware, boolean includeNonDistributedTasks) {
        this._job = job;
        this._configuration = configuration;
        this._taskRunner = taskRunner;
        this._analysisListener = analysisListener;
        this._resultQueue = resultQueue;
        this._includeNonDistributedTasks = includeNonDistributedTasks;
        this._sourceColumnFinder = new SourceColumnFinder();
        this._sourceColumnFinder.addSources(this._job);
        this._errorAware = errorAware;
        this._transformerJobs = this._job.getTransformerJobs();
        this._filterJobs = this._job.getFilterJobs();
        this._analyzerJobs = this._job.getAnalyzerJobs();
    }

    public AnalysisResultFuture run() {
        try {
            InjectionManager injectionManager = this._configuration.getInjectionManager(this._job);
            LifeCycleHelper rowProcessingLifeCycleHelper = new LifeCycleHelper(injectionManager, new ReferenceDataActivationManager(), this._includeNonDistributedTasks);
            RowProcessingPublishers publishers = new RowProcessingPublishers(this._job, this._analysisListener, this._taskRunner, rowProcessingLifeCycleHelper, this._sourceColumnFinder);
            AnalysisJobMetrics analysisJobMetrics = publishers.getAnalysisJobMetrics();
            JobCompletionTaskListener jobCompletionTaskListener = new JobCompletionTaskListener(analysisJobMetrics, this._analysisListener, 1);
            this._analysisListener.jobBegin(this._job, analysisJobMetrics);
            this.validateSingleTableInput(this._transformerJobs);
            this.validateSingleTableInput(this._filterJobs);
            this.validateSingleTableInput(this._analyzerJobs);
            this.scheduleRowProcessing(publishers, rowProcessingLifeCycleHelper, jobCompletionTaskListener, analysisJobMetrics);
            return new AnalysisResultFutureImpl(this._resultQueue, jobCompletionTaskListener, this._errorAware);
        }
        catch (RuntimeException e) {
            this._analysisListener.errorUknown(this._job, e);
            throw e;
        }
    }

    private void scheduleRowProcessing(RowProcessingPublishers publishers, LifeCycleHelper lifeCycleHelper, JobCompletionTaskListener jobCompletionTaskListener, AnalysisJobMetrics analysisJobMetrics) {
        logger.info("Created {} row processor publishers", (Object)publishers.size());
        ArrayList<TaskRunnable> finalTasks = new ArrayList<TaskRunnable>(2);
        finalTasks.add(new TaskRunnable(null, jobCompletionTaskListener));
        finalTasks.add(new TaskRunnable(null, new CloseReferenceDataTaskListener(lifeCycleHelper)));
        ForkTaskListener finalTaskListener = new ForkTaskListener("All row consumers finished", this._taskRunner, finalTasks);
        JoinTaskListener rowProcessorPublishersDoneCompletionListener = new JoinTaskListener(publishers.size(), finalTaskListener);
        Collection<RowProcessingPublisher> rowProcessingPublishers = publishers.getRowProcessingPublishers();
        for (RowProcessingPublisher rowProcessingPublisher : rowProcessingPublishers) {
            logger.debug("Scheduling row processing publisher: {}", (Object)rowProcessingPublisher);
            rowProcessingPublisher.runRowProcessing(this._resultQueue, rowProcessorPublishersDoneCompletionListener);
        }
    }

    private void validateSingleTableInput(Collection<? extends ComponentJob> componentJobs) {
        for (ComponentJob componentJob : componentJobs) {
            InputColumn[] input;
            Table originatingTable = null;
            for (InputColumn inputColumn : input = componentJob.getInput()) {
                Table table = this._sourceColumnFinder.findOriginatingTable(inputColumn);
                if (table == null) continue;
                if (originatingTable == null) {
                    originatingTable = table;
                    continue;
                }
                if (originatingTable.equals(table)) continue;
                throw new IllegalArgumentException("Input columns in " + componentJob + " originate from different tables");
            }
        }
    }
}

