/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import org.datacleaner.api.Analyzer;
import org.datacleaner.api.Concurrent;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.FilterOutcomes;
import org.datacleaner.job.HasComponentRequirement;
import org.datacleaner.job.InputColumnSinkJob;
import org.datacleaner.job.runner.AbstractRowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingChain;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.util.SourceColumnFinder;

final class AnalyzerConsumer
extends AbstractRowProcessingConsumer
implements RowProcessingConsumer {
    private final AnalyzerJob _analyzerJob;
    private final Analyzer<?> _analyzer;
    private final InputColumn<?>[] _inputColumns;
    private final boolean _concurrent;

    public AnalyzerConsumer(Analyzer<?> analyzer, AnalyzerJob analyzerJob, InputColumn<?>[] inputColumns, SourceColumnFinder sourceColumnFinder) {
        super(null, null, (HasComponentRequirement)analyzerJob, (InputColumnSinkJob)analyzerJob, sourceColumnFinder);
        this._analyzer = analyzer;
        this._analyzerJob = analyzerJob;
        this._inputColumns = inputColumns;
        this._concurrent = this.determineConcurrent();
    }

    public AnalyzerConsumer(Analyzer<?> analyzer, AnalyzerJob analyzerJob, InputColumn<?>[] inputColumns, RowProcessingPublishers publishers) {
        super(publishers, (HasComponentRequirement)analyzerJob, (InputColumnSinkJob)analyzerJob);
        this._analyzer = analyzer;
        this._analyzerJob = analyzerJob;
        this._inputColumns = inputColumns;
        this._concurrent = this.determineConcurrent();
    }

    private boolean determineConcurrent() {
        Concurrent concurrent = (Concurrent)this._analyzerJob.getDescriptor().getAnnotation(Concurrent.class);
        if (concurrent == null) {
            return false;
        }
        return concurrent.value();
    }

    public Analyzer<?> getComponent() {
        return this._analyzer;
    }

    @Override
    public boolean isConcurrent() {
        return this._concurrent;
    }

    @Override
    public InputColumn<?>[] getRequiredInput() {
        return this._inputColumns;
    }

    @Override
    public void consumeInternal(InputRow row, int distinctCount, FilterOutcomes outcomes, RowProcessingChain chain) {
        this._analyzer.run(row, distinctCount);
        chain.processNext(row, distinctCount, outcomes);
    }

    public AnalyzerJob getComponentJob() {
        return this._analyzerJob;
    }

    public String toString() {
        return "AnalyzerConsumer[" + this._analyzer + "]";
    }
}

