/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.List;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.ComponentMessage;
import org.datacleaner.api.InputRow;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.AnalyzerMetrics;
import org.datacleaner.job.runner.RowProcessingMetrics;

public final class CompositeAnalysisListener
implements AnalysisListener {
    private final List<AnalysisListener> _delegates;

    public CompositeAnalysisListener(AnalysisListener[] delegates) {
        this._delegates = new ArrayList<AnalysisListener>(delegates.length);
        for (AnalysisListener analysisListener : delegates) {
            this.addDelegate(analysisListener);
        }
    }

    public CompositeAnalysisListener(AnalysisListener firstDelegate, AnalysisListener ... delegates) {
        this._delegates = new ArrayList<AnalysisListener>(1 + delegates.length);
        this.addDelegate(firstDelegate);
        for (AnalysisListener analysisListener : delegates) {
            this.addDelegate(analysisListener);
        }
    }

    public void addDelegate(AnalysisListener analysisListener) {
        if (analysisListener == null) {
            return;
        }
        this._delegates.add(analysisListener);
    }

    public boolean isEmpty() {
        return this._delegates.isEmpty();
    }

    public int size() {
        return this._delegates.size();
    }

    @Override
    public void jobBegin(AnalysisJob job, AnalysisJobMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.jobBegin(job, metrics);
        }
    }

    @Override
    public void onComponentMessage(AnalysisJob job, ComponentJob componentJob, ComponentMessage message) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.onComponentMessage(job, componentJob, message);
        }
    }

    @Override
    public void jobSuccess(AnalysisJob job, AnalysisJobMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.jobSuccess(job, metrics);
        }
    }

    @Override
    public void rowProcessingBegin(AnalysisJob job, RowProcessingMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.rowProcessingBegin(job, metrics);
        }
    }

    @Override
    public void rowProcessingProgress(AnalysisJob job, RowProcessingMetrics metrics, InputRow row, int currentRow) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.rowProcessingProgress(job, metrics, row, currentRow);
        }
    }

    @Override
    public void rowProcessingSuccess(AnalysisJob job, RowProcessingMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.rowProcessingSuccess(job, metrics);
        }
    }

    @Override
    public void analyzerBegin(AnalysisJob job, AnalyzerJob analyzerJob, AnalyzerMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.analyzerBegin(job, analyzerJob, metrics);
        }
    }

    @Override
    public void analyzerSuccess(AnalysisJob job, AnalyzerJob analyzerJob, AnalyzerResult result) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.analyzerSuccess(job, analyzerJob, result);
        }
    }

    @Override
    public void errorInComponent(AnalysisJob job, ComponentJob componentJob, InputRow row, Throwable throwable) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.errorInComponent(job, componentJob, row, throwable);
        }
    }

    @Override
    public void errorUknown(AnalysisJob job, Throwable throwable) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.errorUknown(job, throwable);
        }
    }
}

