/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.configuration.AnalyzerBeansConfiguration;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.concurrent.SingleThreadedTaskRunner;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.ConsumeRowHandlerDelegate;
import org.datacleaner.job.runner.ConsumeRowResult;
import org.datacleaner.job.runner.FilterOutcomesImpl;
import org.datacleaner.job.runner.InfoLoggingAnalysisListener;
import org.datacleaner.job.runner.ReferenceDataActivationManager;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.job.tasks.Task;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.util.SourceColumnFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeRowHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConsumeRowHandler.class);
    private final List<RowProcessingConsumer> _consumers;
    private final Collection<? extends FilterOutcome> _alwaysSatisfiedOutcomes;

    public ConsumeRowHandler(AnalysisJob job, AnalyzerBeansConfiguration analyzerBeansConfiguration, Configuration configuration) {
        this._consumers = this.extractConsumers(job, analyzerBeansConfiguration, configuration);
        this._alwaysSatisfiedOutcomes = configuration.alwaysSatisfiedOutcomes;
    }

    public ConsumeRowHandler(List<RowProcessingConsumer> consumers) {
        this(consumers, null);
    }

    public ConsumeRowHandler(List<RowProcessingConsumer> consumers, Collection<? extends FilterOutcome> alwaysSatisfiedOutcomes) {
        this._consumers = consumers;
        this._alwaysSatisfiedOutcomes = alwaysSatisfiedOutcomes;
    }

    public List<RowProcessingConsumer> getConsumers() {
        return this._consumers;
    }

    public List<InputColumn<?>> getOutputColumns() {
        ArrayList result = new ArrayList();
        for (RowProcessingConsumer consumer : this._consumers) {
            InputColumn<?>[] outputColumns;
            for (InputColumn<?> outputColumn : outputColumns = consumer.getOutputColumns()) {
                result.add(outputColumn);
            }
        }
        return result;
    }

    @Deprecated
    public List<InputRow> consume(InputRow row) {
        ConsumeRowResult result = this.consumeRow(row);
        return result.getRows();
    }

    public ConsumeRowResult consumeRow(InputRow row) {
        FilterOutcomesImpl outcomes = new FilterOutcomesImpl(this._alwaysSatisfiedOutcomes);
        ConsumeRowHandlerDelegate delegate = new ConsumeRowHandlerDelegate(this._consumers, row, 0, outcomes);
        ConsumeRowResult result = delegate.consume();
        return result;
    }

    private List<RowProcessingConsumer> extractConsumers(AnalysisJob analysisJob, AnalyzerBeansConfiguration analyzerBeansConfiguration, Configuration configuration) {
        RowProcessingPublisher publisher;
        InjectionManager injectionManager = analyzerBeansConfiguration.getInjectionManager(analysisJob);
        ReferenceDataActivationManager referenceDataActivationManager = new ReferenceDataActivationManager();
        LifeCycleHelper lifeCycleHelper = new LifeCycleHelper(injectionManager, referenceDataActivationManager, configuration.includeNonDistributedTasks);
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(analysisJob);
        SingleThreadedTaskRunner taskRunner = new SingleThreadedTaskRunner();
        AnalysisListener analysisListener = configuration.analysisListener;
        RowProcessingPublishers rowProcessingPublishers = new RowProcessingPublishers(analysisJob, analysisListener, taskRunner, lifeCycleHelper, sourceColumnFinder);
        if (configuration.table != null) {
            publisher = rowProcessingPublishers.getRowProcessingPublisher(configuration.table);
            if (publisher == null) {
                throw new IllegalArgumentException("Job does not consume records from table: " + configuration.table);
            }
        } else {
            Collection<RowProcessingPublisher> publisherCollection = rowProcessingPublishers.getRowProcessingPublishers();
            if (publisherCollection.size() > 1) {
                throw new IllegalArgumentException("Job consumes multiple tables, but ConsumeRowHandler can only handle a single table's components. Please specify a Table constructor argument.");
            }
            publisher = publisherCollection.iterator().next();
        }
        final AtomicReference errorReference = new AtomicReference();
        publisher.initializeConsumers(new TaskListener(){

            @Override
            public void onError(Task task, Throwable throwable) {
                logger.error("Exception thrown while initializing consumers.", throwable);
                errorReference.compareAndSet(null, throwable);
            }

            @Override
            public void onComplete(Task task) {
                logger.info("Consumers initialized successfully.");
            }

            @Override
            public void onBegin(Task task) {
                logger.info("Beginning the process of initializing consumers.");
            }
        });
        Throwable throwable = (Throwable)errorReference.get();
        if (throwable == null || throwable instanceof RuntimeException) {
            // empty if block
        }
        List<RowProcessingConsumer> consumers = publisher.getConfigurableConsumers();
        if (!configuration.includeAnalyzers) {
            consumers = this.removeAnalyzers(consumers);
        }
        consumers = RowProcessingPublisher.sortConsumers(consumers);
        return consumers;
    }

    private List<RowProcessingConsumer> removeAnalyzers(List<RowProcessingConsumer> consumers) {
        ArrayList<RowProcessingConsumer> result = new ArrayList<RowProcessingConsumer>();
        for (RowProcessingConsumer rowProcessingConsumer : consumers) {
            Object component = rowProcessingConsumer.getComponent();
            if (component instanceof Analyzer) continue;
            result.add(rowProcessingConsumer);
        }
        return result;
    }

    public static class Configuration {
        public boolean includeNonDistributedTasks = true;
        public AnalysisListener analysisListener = new InfoLoggingAnalysisListener();
        public boolean includeAnalyzers = true;
        public Collection<? extends FilterOutcome> alwaysSatisfiedOutcomes;
        public Table table;
    }
}

