/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.List;
import org.datacleaner.api.InputRow;
import org.datacleaner.job.FilterOutcomes;
import org.datacleaner.job.runner.ConsumeRowResult;
import org.datacleaner.job.runner.RowProcessingChain;
import org.datacleaner.job.runner.RowProcessingConsumer;

final class ConsumeRowHandlerDelegate
implements RowProcessingChain {
    private final List<RowProcessingConsumer> _consumers;
    private final InputRow _row;
    private final int _consumerIndex;
    private final FilterOutcomes _outcomes;
    private final List<InputRow> _resultRecords;
    private final List<FilterOutcomes> _resultOutcomes;

    public ConsumeRowHandlerDelegate(List<RowProcessingConsumer> consumers, InputRow row, int consumerIndex, FilterOutcomes outcomes) {
        this(consumers, row, consumerIndex, outcomes, new ArrayList<InputRow>(1), new ArrayList<FilterOutcomes>(1));
    }

    private ConsumeRowHandlerDelegate(List<RowProcessingConsumer> consumers, InputRow row, int consumerIndex, FilterOutcomes outcomes, List<InputRow> resultRecords, List<FilterOutcomes> resultOutcomes) {
        this._consumers = consumers;
        this._row = row;
        this._consumerIndex = consumerIndex;
        this._outcomes = outcomes;
        this._resultRecords = resultRecords;
        this._resultOutcomes = resultOutcomes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumeRowResult consume() {
        RowProcessingConsumer consumer = this._consumers.get(this._consumerIndex);
        boolean process = consumer.satisfiedForConsume(this._outcomes, this._row);
        if (process) {
            if (consumer.isConcurrent()) {
                consumer.consume(this._row, 1, this._outcomes, this);
            } else {
                RowProcessingConsumer rowProcessingConsumer = consumer;
                synchronized (rowProcessingConsumer) {
                    consumer.consume(this._row, 1, this._outcomes, this);
                }
            }
        } else {
            this.processNext(this._row, 1, this._outcomes);
        }
        return new ConsumeRowResult(this._resultRecords, this._resultOutcomes);
    }

    @Override
    public void processNext(InputRow row, int distinctCount, FilterOutcomes outcomes) {
        int nextIndex = this._consumerIndex + 1;
        if (nextIndex >= this._consumers.size()) {
            this._resultRecords.add(row);
            this._resultOutcomes.add(outcomes);
            return;
        }
        ConsumeRowHandlerDelegate subDelegate = new ConsumeRowHandlerDelegate(this._consumers, row, nextIndex, outcomes, this._resultRecords, this._resultOutcomes);
        subDelegate.consume();
    }
}

