/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import org.datacleaner.api.Concurrent;
import org.datacleaner.api.Filter;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.Optimizeable;
import org.datacleaner.api.QueryOptimizedFilter;
import org.datacleaner.job.FilterJob;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.FilterOutcomes;
import org.datacleaner.job.HasComponentRequirement;
import org.datacleaner.job.ImmutableFilterOutcome;
import org.datacleaner.job.InputColumnSinkJob;
import org.datacleaner.job.runner.AbstractRowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingChain;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.SourceColumnFinder;

final class FilterConsumer
extends AbstractRowProcessingConsumer
implements RowProcessingConsumer {
    private final Filter<?> _filter;
    private final FilterJob _filterJob;
    private final InputColumn<?>[] _inputColumns;
    private final boolean _concurrent;

    public FilterConsumer(Filter<?> filter, FilterJob filterJob, InputColumn<?>[] inputColumns, SourceColumnFinder sourceColumnFinder) {
        super(null, null, (HasComponentRequirement)filterJob, (InputColumnSinkJob)filterJob, sourceColumnFinder);
        this._filter = filter;
        this._filterJob = filterJob;
        this._inputColumns = inputColumns;
        this._concurrent = this.determineConcurrent();
    }

    public FilterConsumer(Filter<?> filter, FilterJob filterJob, InputColumn<?>[] inputColumns, RowProcessingPublishers publishers) {
        super(publishers, (HasComponentRequirement)filterJob, (InputColumnSinkJob)filterJob);
        this._filter = filter;
        this._filterJob = filterJob;
        this._inputColumns = inputColumns;
        this._concurrent = this.determineConcurrent();
    }

    private boolean determineConcurrent() {
        Concurrent concurrent = (Concurrent)this._filterJob.getDescriptor().getAnnotation(Concurrent.class);
        if (concurrent == null) {
            return true;
        }
        return concurrent.value();
    }

    @Override
    public boolean isConcurrent() {
        return this._concurrent;
    }

    @Override
    public InputColumn<?>[] getRequiredInput() {
        return this._inputColumns;
    }

    public Filter<?> getComponent() {
        return this._filter;
    }

    @Override
    public void consumeInternal(InputRow row, int distinctCount, FilterOutcomes outcomes, RowProcessingChain chain) {
        Enum category = this._filter.categorize(row);
        ImmutableFilterOutcome outcome = new ImmutableFilterOutcome(this._filterJob, category);
        outcomes.add((FilterOutcome)outcome);
        chain.processNext(row, distinctCount, outcomes);
    }

    public FilterJob getComponentJob() {
        return this._filterJob;
    }

    public String toString() {
        return "FilterConsumer[" + this._filter + "]";
    }

    public boolean isQueryOptimizable(FilterOutcome filterOutcome) {
        if (this._filter instanceof QueryOptimizedFilter) {
            QueryOptimizedFilter queryOptimizedFilter = (QueryOptimizedFilter)this._filter;
            boolean optimizable = queryOptimizedFilter.isOptimizable(filterOutcome.getCategory());
            return optimizable;
        }
        return false;
    }

    public boolean isRemoveableUponOptimization() {
        Optimizeable optimizeable = ReflectionUtils.getAnnotation(this._filterJob.getDescriptor().getComponentClass(), Optimizeable.class);
        if (optimizeable == null) {
            return true;
        }
        return optimizeable.removeableUponOptimization();
    }
}

