/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import org.datacleaner.api.ComponentMessage;
import org.datacleaner.api.ExecutionLogMessage;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisListenerAdaptor;
import org.datacleaner.job.runner.RowProcessingMetrics;
import org.datacleaner.util.LabelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoLoggingAnalysisListener
extends AnalysisListenerAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(InfoLoggingAnalysisListener.class);

    public static boolean isEnabled() {
        return logger.isInfoEnabled();
    }

    @Override
    public void rowProcessingBegin(AnalysisJob job, RowProcessingMetrics metrics) {
        logger.info("Beginning row processing of {}", (Object)metrics.getTable());
    }

    @Override
    public void rowProcessingProgress(AnalysisJob job, RowProcessingMetrics metrics, int currentRow) {
        if (currentRow > 0 && currentRow % 1000 == 0) {
            logger.info("Reading row no. {} in {}", new Object[]{currentRow, metrics.getTable().getName()});
        }
    }

    @Override
    public void onComponentMessage(AnalysisJob job, ComponentJob componentJob, ComponentMessage message) {
        if (message instanceof ExecutionLogMessage) {
            logger.info(((ExecutionLogMessage)message).getMessage() + " (" + LabelUtils.getLabel(componentJob) + ")");
        }
    }
}

