/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.tasks.Task;

public final class RowConsumerTaskListener
implements TaskListener {
    private final AtomicInteger _counter = new AtomicInteger();
    private final AtomicBoolean _errorsReported = new AtomicBoolean(false);
    private final AnalysisListener _analysisListener;
    private final AnalysisJob _analysisJob;
    private final TaskRunner _taskRunner;

    public RowConsumerTaskListener(AnalysisJob analysisJob, AnalysisListener analysisListener, TaskRunner taskRunner) {
        this._analysisListener = analysisListener;
        this._analysisJob = analysisJob;
        this._taskRunner = taskRunner;
    }

    @Override
    public void onBegin(Task task) {
    }

    @Override
    public void onComplete(Task task) {
        this.incrementCounter();
    }

    @Override
    public void onError(Task task, Throwable throwable) {
        boolean alreadyRegisteredError = this._errorsReported.getAndSet(true);
        if (!alreadyRegisteredError) {
            this._analysisListener.errorUknown(this._analysisJob, throwable);
        }
        this.incrementCounter();
    }

    private void incrementCounter() {
        this._counter.incrementAndGet();
    }

    public boolean isErrornous() {
        return this._errorsReported.get();
    }

    public void awaitTasks(int numTasks) {
        while (numTasks > this._counter.get() && !this.isErrornous()) {
            this._taskRunner.assistExecution();
        }
    }
}

