/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.LazyRef;
import org.apache.metamodel.util.Ref;
import org.datacleaner.components.convert.ConvertToNumberTransformer;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.RowProcessingMetrics;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.job.runner.RowProcessingPublishers;

final class RowProcessingMetricsImpl
implements RowProcessingMetrics {
    private final RowProcessingPublishers _publishers;
    private final RowProcessingPublisher _publisher;
    private final Ref<Integer> _expectedRows;

    public RowProcessingMetricsImpl(RowProcessingPublishers publishers, RowProcessingPublisher publisher) {
        this._publishers = publishers;
        this._publisher = publisher;
        this._expectedRows = this.createExpectedRowsRef();
    }

    @Override
    public AnalysisJobMetrics getAnalysisJobMetrics() {
        return this._publishers.getAnalysisJobMetrics();
    }

    @Override
    public Query getQuery() {
        return this._publisher.getQuery();
    }

    @Override
    public Table getTable() {
        return this._publisher.getTable();
    }

    @Override
    public int getExpectedRows() {
        Integer expectedRows = (Integer)this._expectedRows.get();
        return expectedRows;
    }

    @Override
    public AnalyzerJob[] getAnalyzerJobs() {
        return this._publisher.getAnalyzerJobs();
    }

    private Ref<Integer> createExpectedRowsRef() {
        return new LazyRef<Integer>(){

            protected Integer fetch() {
                int expectedRows = -1;
                Query originalQuery = RowProcessingMetricsImpl.this.getQuery();
                Query countQuery = originalQuery.clone();
                countQuery.setMaxRows(null);
                countQuery.setFirstRow(null);
                countQuery.getSelectClause().removeItems();
                countQuery.getOrderByClause().removeItems();
                countQuery.selectCount();
                ((SelectItem)countQuery.getSelectClause().getItem(0)).setFunctionApproximationAllowed(true);
                Datastore datastore = RowProcessingMetricsImpl.this._publishers.getDatastore();
                try (DatastoreConnection connection = datastore.openConnection();
                     DataSet countDataSet = connection.getDataContext().executeQuery(countQuery);){
                    Number count;
                    if (countDataSet.next() && (count = ConvertToNumberTransformer.transformValue(countDataSet.getRow().getValue(0))) != null) {
                        expectedRows = count.intValue();
                    }
                }
                Integer maxRows = originalQuery.getMaxRows();
                if (maxRows != null) {
                    expectedRows = Math.min(expectedRows, maxRows);
                }
                return expectedRows;
            }
        };
    }
}

