/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.LazyRef;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.Filter;
import org.datacleaner.api.HasAnalyzerResult;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.Transformer;
import org.datacleaner.configuration.ContextAwareInjectionManager;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.data.MetaModelInputRow;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.FilterJob;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.HasFilterOutcomes;
import org.datacleaner.job.TransformerJob;
import org.datacleaner.job.concurrent.ForkTaskListener;
import org.datacleaner.job.concurrent.JoinTaskListener;
import org.datacleaner.job.concurrent.RunNextTaskTaskListener;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.concurrent.TaskRunnable;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.AnalyzerConsumer;
import org.datacleaner.job.runner.AnalyzerMetrics;
import org.datacleaner.job.runner.ConsumeRowHandler;
import org.datacleaner.job.runner.FilterConsumer;
import org.datacleaner.job.runner.JobAndResult;
import org.datacleaner.job.runner.ReferenceDataActivationManager;
import org.datacleaner.job.runner.RowConsumerTaskListener;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingConsumerSorter;
import org.datacleaner.job.runner.RowProcessingMetrics;
import org.datacleaner.job.runner.RowProcessingMetricsImpl;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.job.runner.RowProcessingQueryOptimizer;
import org.datacleaner.job.runner.SimpleRowIdGenerator;
import org.datacleaner.job.runner.TransformerConsumer;
import org.datacleaner.job.tasks.CloseTaskListener;
import org.datacleaner.job.tasks.CollectResultsTask;
import org.datacleaner.job.tasks.ConsumeRowTask;
import org.datacleaner.job.tasks.InitializeReferenceDataTask;
import org.datacleaner.job.tasks.InitializeTask;
import org.datacleaner.job.tasks.RunRowProcessingPublisherTask;
import org.datacleaner.job.tasks.Task;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RowProcessingPublisher {
    private static final Logger logger = LoggerFactory.getLogger(RowProcessingPublisher.class);
    private final RowProcessingPublishers _publishers;
    private final Table _table;
    private final Set<Column> _physicalColumns = new LinkedHashSet<Column>();
    private final List<RowProcessingConsumer> _consumers = new ArrayList<RowProcessingConsumer>();
    private final LazyRef<RowProcessingQueryOptimizer> _queryOptimizerRef;
    private final AtomicBoolean _successful = new AtomicBoolean(true);

    public RowProcessingPublisher(RowProcessingPublishers publishers, Table table) {
        if (publishers == null) {
            throw new IllegalArgumentException("RowProcessingPublishers cannot be null");
        }
        if (table == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        this._publishers = publishers;
        this._table = table;
        this._queryOptimizerRef = this.createQueryOptimizerRef();
        if (!"true".equalsIgnoreCase("datacleaner.query.selectclause.optimize")) {
            List sourceColumns = publishers.getAnalysisJob().getSourceColumns();
            ArrayList<Column> columns = new ArrayList<Column>();
            for (InputColumn sourceColumn : sourceColumns) {
                Column column = sourceColumn.getPhysicalColumn();
                if (column == null || !table.equals(column.getTable())) continue;
                columns.add(column);
            }
            this.addPhysicalColumns(columns.toArray(new Column[columns.size()]));
        }
    }

    public RowProcessingMetrics getRowProcessingMetrics() {
        RowProcessingMetricsImpl metrics = new RowProcessingMetricsImpl(this._publishers, this);
        return metrics;
    }

    public Table getTable() {
        return this._table;
    }

    public void addPrimaryKeysIfSourced() {
        Column[] primaryKeyColumns = this._table.getPrimaryKeys();
        if (primaryKeyColumns == null || primaryKeyColumns.length == 0) {
            logger.info("No primary keys defined for table {}, not pre-selecting primary keys", (Object)this._table.getName());
            return;
        }
        AnalysisJob analysisJob = this._publishers.getAnalysisJob();
        List sourceInputColumns = analysisJob.getSourceColumns();
        List sourceColumns = CollectionUtils.map((Iterable)sourceInputColumns, (Func)new Func<InputColumn<?>, Column>(){

            public Column eval(InputColumn<?> inputColumn) {
                return inputColumn.getPhysicalColumn();
            }
        });
        for (Column primaryKeyColumn : primaryKeyColumns) {
            if (sourceColumns.contains(primaryKeyColumn)) continue;
            logger.info("Primary key column {} not added to source columns, not pre-selecting primary keys");
            return;
        }
        this.addPhysicalColumns(primaryKeyColumns);
    }

    private LazyRef<RowProcessingQueryOptimizer> createQueryOptimizerRef() {
        return new LazyRef<RowProcessingQueryOptimizer>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected RowProcessingQueryOptimizer fetch() {
                Datastore datastore = RowProcessingPublisher.this._publishers.getDatastore();
                try (DatastoreConnection con = datastore.openConnection();){
                    RowProcessingQueryOptimizer optimizer;
                    DataContext dataContext = con.getDataContext();
                    Column[] columnArray = RowProcessingPublisher.this._physicalColumns.toArray(new Column[RowProcessingPublisher.this._physicalColumns.size()]);
                    Query baseQuery = dataContext.query().from(RowProcessingPublisher.this._table).select(columnArray).toQuery();
                    logger.debug("Base query for row processing: {}", (Object)baseQuery);
                    List<RowProcessingConsumer> sortedConsumers = RowProcessingPublisher.sortConsumers(RowProcessingPublisher.this._consumers);
                    RowProcessingQueryOptimizer rowProcessingQueryOptimizer = optimizer = new RowProcessingQueryOptimizer(datastore, sortedConsumers, baseQuery);
                    return rowProcessingQueryOptimizer;
                }
                catch (RuntimeException e) {
                    logger.error("Failed to build query optimizer! {}", (Object)e.getMessage(), (Object)e);
                    throw e;
                }
            }
        };
    }

    public static List<RowProcessingConsumer> sortConsumers(List<RowProcessingConsumer> consumers) {
        RowProcessingConsumerSorter sorter = new RowProcessingConsumerSorter(consumers);
        List<RowProcessingConsumer> sortedConsumers = sorter.createProcessOrderedConsumerList();
        if (logger.isDebugEnabled()) {
            logger.debug("Row processing order ({} consumers):", (Object)sortedConsumers.size());
            int i = 1;
            for (RowProcessingConsumer rowProcessingConsumer : sortedConsumers) {
                logger.debug(" {}) {}", (Object)i, (Object)rowProcessingConsumer);
                ++i;
            }
        }
        return sortedConsumers;
    }

    public void initialize() {
        this._queryOptimizerRef.requestLoad();
    }

    public void addPhysicalColumns(Column ... columns) {
        for (Column column : columns) {
            if (!this._table.equals(column.getTable())) {
                throw new IllegalArgumentException("Column does not pertain to the correct table. Expected table: " + this._table + ", actual table: " + column.getTable());
            }
            this._physicalColumns.add(column);
        }
    }

    public RowProcessingQueryOptimizer getQueryOptimizer() {
        RowProcessingQueryOptimizer optimizer = (RowProcessingQueryOptimizer)this._queryOptimizerRef.get();
        if (optimizer == null) {
            Throwable e = this._queryOptimizerRef.getError();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
        return optimizer;
    }

    public Query getQuery() {
        return this.getQueryOptimizer().getOptimizedQuery();
    }

    public void processRows(RowProcessingMetrics rowProcessingMetrics) {
        RowProcessingQueryOptimizer queryOptimizer = this.getQueryOptimizer();
        Query finalQuery = queryOptimizer.getOptimizedQuery();
        SimpleRowIdGenerator idGenerator = finalQuery.getFirstRow() == null ? new SimpleRowIdGenerator() : new SimpleRowIdGenerator(finalQuery.getFirstRow());
        AnalysisJob analysisJob = this._publishers.getAnalysisJob();
        AnalysisListener analysisListener = this._publishers.getAnalysisListener();
        TaskRunner taskRunner = this._publishers.getTaskRunner();
        for (RowProcessingConsumer rowProcessingConsumer : this._consumers) {
            if (rowProcessingConsumer instanceof AnalyzerConsumer) {
                AnalyzerConsumer analyzerConsumer = (AnalyzerConsumer)rowProcessingConsumer;
                AnalyzerJob analyzerJob = analyzerConsumer.getComponentJob();
                AnalyzerMetrics metrics = rowProcessingMetrics.getAnalysisJobMetrics().getAnalyzerMetrics(analyzerJob);
                analysisListener.analyzerBegin(analysisJob, analyzerJob, metrics);
            }
            if (!(rowProcessingConsumer instanceof TransformerConsumer)) continue;
            ((TransformerConsumer)rowProcessingConsumer).setRowIdGenerator(idGenerator);
        }
        List<RowProcessingConsumer> consumers = queryOptimizer.getOptimizedConsumers();
        Collection<? extends FilterOutcome> availableOutcomes = queryOptimizer.getOptimizedAvailableOutcomes();
        analysisListener.rowProcessingBegin(analysisJob, rowProcessingMetrics);
        RowConsumerTaskListener taskListener = new RowConsumerTaskListener(analysisJob, analysisListener, taskRunner);
        Datastore datastore = this._publishers.getDatastore();
        try (DatastoreConnection con = datastore.openConnection();){
            DataContext dataContext = con.getDataContext();
            if (logger.isDebugEnabled()) {
                String queryString;
                if (dataContext instanceof JdbcDataContext) {
                    JdbcDataContext jdbcDataContext = (JdbcDataContext)dataContext;
                    queryString = jdbcDataContext.getQueryRewriter().rewriteQuery(finalQuery);
                } else {
                    queryString = finalQuery.toSql();
                }
                logger.debug("Final query: {}", (Object)queryString);
                logger.debug("Final query firstRow={}, maxRows={}", (Object)finalQuery.getFirstRow(), (Object)finalQuery.getMaxRows());
            }
            int numTasks = 0;
            try (DataSet dataSet = dataContext.executeQuery(finalQuery);){
                ConsumeRowHandler consumeRowHandler = new ConsumeRowHandler(consumers, availableOutcomes);
                while (dataSet.next()) {
                    if (taskListener.isErrornous()) {
                        break;
                    }
                    Row metaModelRow = dataSet.getRow();
                    int rowId = idGenerator.nextPhysicalRowId();
                    MetaModelInputRow inputRow = new MetaModelInputRow(rowId, metaModelRow);
                    ConsumeRowTask task = new ConsumeRowTask(consumeRowHandler, rowProcessingMetrics, inputRow, analysisListener, ++numTasks);
                    taskRunner.run(task, taskListener);
                }
            }
            taskListener.awaitTasks(numTasks);
        }
        if (taskListener.isErrornous()) {
            this._successful.set(false);
            return;
        }
        analysisListener.rowProcessingSuccess(analysisJob, rowProcessingMetrics);
    }

    public void addAnalyzerBean(Analyzer<?> analyzer, AnalyzerJob analyzerJob, InputColumn<?>[] inputColumns) {
        this.addConsumer(new AnalyzerConsumer(analyzer, analyzerJob, inputColumns, this._publishers));
    }

    public void addTransformerBean(Transformer transformer, TransformerJob transformerJob, InputColumn<?>[] inputColumns) {
        this.addConsumer(new TransformerConsumer(transformer, transformerJob, inputColumns, this._publishers));
    }

    public void addFilterBean(Filter<?> filter, FilterJob filterJob, InputColumn<?>[] inputColumns) {
        this.addConsumer(new FilterConsumer(filter, filterJob, inputColumns, this._publishers));
    }

    public boolean containsOutcome(FilterOutcome prerequisiteOutcome) {
        for (RowProcessingConsumer consumer : this._consumers) {
            ComponentJob componentJob = consumer.getComponentJob();
            if (!(componentJob instanceof HasFilterOutcomes)) continue;
            Collection outcomes = ((HasFilterOutcomes)componentJob).getFilterOutcomes();
            for (FilterOutcome outcome : outcomes) {
                if (!outcome.isEquals(prerequisiteOutcome)) continue;
                return true;
            }
        }
        return false;
    }

    private void addConsumer(RowProcessingConsumer consumer) {
        this._consumers.add(consumer);
    }

    public List<RowProcessingConsumer> getConfigurableConsumers() {
        return Collections.unmodifiableList(this._consumers);
    }

    public void runRowProcessing(Queue<JobAndResult> resultQueue, TaskListener finishedTaskListener) {
        LifeCycleHelper lifeCycleHelper = this._publishers.getLifeCycleHelper();
        TaskRunner taskRunner = this._publishers.getTaskRunner();
        List<RowProcessingConsumer> configurableConsumers = this.getConfigurableConsumers();
        int numConsumerTasks = configurableConsumers.size();
        JoinTaskListener closeTaskListener = new JoinTaskListener(numConsumerTasks, finishedTaskListener);
        ArrayList<TaskRunnable> closeTasks = new ArrayList<TaskRunnable>(numConsumerTasks);
        for (RowProcessingConsumer consumer : configurableConsumers) {
            closeTasks.add(this.createCloseTask(consumer, closeTaskListener));
        }
        ForkTaskListener getResultCompletionListener = new ForkTaskListener("collect results", taskRunner, closeTasks);
        JoinTaskListener getResultTaskListener = new JoinTaskListener(numConsumerTasks, getResultCompletionListener);
        ArrayList<TaskRunnable> getResultTasks = new ArrayList<TaskRunnable>();
        for (RowProcessingConsumer consumer : configurableConsumers) {
            Task collectResultTask = this.createCollectResultTask(consumer, resultQueue);
            if (collectResultTask == null) {
                getResultTasks.add(new TaskRunnable(null, getResultTaskListener));
                continue;
            }
            getResultTasks.add(new TaskRunnable(collectResultTask, getResultTaskListener));
        }
        ForkTaskListener runCompletionListener = new ForkTaskListener("run row processing", taskRunner, getResultTasks);
        RowProcessingMetrics rowProcessingMetrics = this.getRowProcessingMetrics();
        RunRowProcessingPublisherTask runTask = new RunRowProcessingPublisherTask(this, rowProcessingMetrics);
        ForkTaskListener referenceDataInitFinishedListener = new ForkTaskListener("Initialize row consumers", taskRunner, Arrays.asList(new TaskRunnable(runTask, runCompletionListener)));
        RunNextTaskTaskListener initializeFinishedListener = new RunNextTaskTaskListener(taskRunner, new InitializeReferenceDataTask(lifeCycleHelper), referenceDataInitFinishedListener);
        this.initializeConsumers(initializeFinishedListener);
    }

    public void initializeConsumers(TaskListener finishedListener) {
        List<RowProcessingConsumer> configurableConsumers = this.getConfigurableConsumers();
        int numConfigurableConsumers = configurableConsumers.size();
        JoinTaskListener initFinishedListener = new JoinTaskListener(numConfigurableConsumers, finishedListener);
        TaskRunner taskRunner = this._publishers.getTaskRunner();
        for (RowProcessingConsumer consumer : configurableConsumers) {
            TaskRunnable task = this.createInitTask(consumer, initFinishedListener);
            taskRunner.run(task);
        }
    }

    public void closeConsumers() {
        List<RowProcessingConsumer> configurableConsumers = this.getConfigurableConsumers();
        TaskRunner taskRunner = this._publishers.getTaskRunner();
        for (RowProcessingConsumer consumer : configurableConsumers) {
            TaskRunnable task = this.createCloseTask(consumer, null);
            taskRunner.run(task);
        }
    }

    private Task createCollectResultTask(RowProcessingConsumer consumer, Queue<JobAndResult> resultQueue) {
        if (consumer instanceof TransformerConsumer || consumer instanceof FilterConsumer) {
            return null;
        }
        if (consumer instanceof AnalyzerConsumer) {
            AnalyzerConsumer analyzerConsumer = (AnalyzerConsumer)consumer;
            Analyzer<?> analyzer = analyzerConsumer.getComponent();
            AnalysisJob analysisJob = this._publishers.getAnalysisJob();
            AnalysisListener analysisListener = this._publishers.getAnalysisListener();
            return new CollectResultsTask((HasAnalyzerResult<?>)analyzer, analysisJob, consumer.getComponentJob(), (Collection<JobAndResult>)resultQueue, analysisListener);
        }
        throw new IllegalStateException("Unknown consumer type: " + consumer);
    }

    private TaskRunnable createCloseTask(RowProcessingConsumer consumer, TaskListener closeTaskListener) {
        LifeCycleHelper lifeCycleHelper = this._publishers.getLifeCycleHelper();
        ComponentDescriptor descriptor = consumer.getComponentJob().getDescriptor();
        Object component = consumer.getComponent();
        return new TaskRunnable(null, new CloseTaskListener(lifeCycleHelper, descriptor, component, this._successful, closeTaskListener));
    }

    private TaskRunnable createInitTask(RowProcessingConsumer consumer, TaskListener listener) {
        ComponentJob componentJob = consumer.getComponentJob();
        Object component = consumer.getComponent();
        ComponentConfiguration configuration = componentJob.getConfiguration();
        ComponentDescriptor descriptor = componentJob.getDescriptor();
        LifeCycleHelper outerLifeCycleHelper = this._publishers.getLifeCycleHelper();
        boolean includeNonDistributedTasks = outerLifeCycleHelper.isIncludeNonDistributedTasks();
        AnalysisJob analysisJob = this._publishers.getAnalysisJob();
        InjectionManager outerInjectionManager = outerLifeCycleHelper.getInjectionManager();
        ReferenceDataActivationManager referenceDataActivationManager = outerLifeCycleHelper.getReferenceDataActivationManager();
        ContextAwareInjectionManager injectionManager = new ContextAwareInjectionManager(outerInjectionManager, analysisJob, componentJob, this._publishers.getAnalysisListener());
        LifeCycleHelper lifeCycleHelper = new LifeCycleHelper(injectionManager, referenceDataActivationManager, includeNonDistributedTasks);
        InitializeTask task = new InitializeTask(lifeCycleHelper, descriptor, component, configuration);
        return new TaskRunnable(task, listener);
    }

    public String toString() {
        return "RowProcessingPublisher[table=" + this._table.getQualifiedLabel() + ", consumers=" + this._consumers.size() + "]";
    }

    public AnalyzerJob[] getAnalyzerJobs() {
        ArrayList<AnalyzerJob> analyzerJobs = new ArrayList<AnalyzerJob>();
        for (RowProcessingConsumer consumer : this._consumers) {
            if (!(consumer instanceof AnalyzerConsumer)) continue;
            AnalyzerJob analyzerJob = ((AnalyzerConsumer)consumer).getComponentJob();
            analyzerJobs.add(analyzerJob);
        }
        return analyzerJobs.toArray(new AnalyzerJob[analyzerJobs.size()]);
    }
}

