/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.Filter;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.Transformer;
import org.datacleaner.connection.Datastore;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterJob;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.TransformerJob;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.AnalysisJobMetricsImpl;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.util.SourceColumnFinder;

public final class RowProcessingPublishers {
    private final AnalysisJob _analysisJob;
    private final AnalysisListener _analysisListener;
    private final TaskRunner _taskRunner;
    private final LifeCycleHelper _lifeCycleHelper;
    private final SourceColumnFinder _sourceColumnFinder;
    private final Map<Table, RowProcessingPublisher> _rowProcessingPublishers;

    public RowProcessingPublishers(AnalysisJob analysisJob, AnalysisListener analysisListener, TaskRunner taskRunner, LifeCycleHelper lifeCycleHelper, SourceColumnFinder sourceColumnFinder) {
        this._analysisJob = analysisJob;
        this._analysisListener = analysisListener;
        this._taskRunner = taskRunner;
        this._lifeCycleHelper = lifeCycleHelper;
        if (sourceColumnFinder == null) {
            this._sourceColumnFinder = new SourceColumnFinder();
            this._sourceColumnFinder.addSources(this._analysisJob);
        } else {
            this._sourceColumnFinder = sourceColumnFinder;
        }
        this._rowProcessingPublishers = new HashMap<Table, RowProcessingPublisher>();
        this.initialize();
    }

    private void initialize() {
        for (FilterJob filterJob : this._analysisJob.getFilterJobs()) {
            this.registerRowProcessingPublishers((ComponentJob)filterJob);
        }
        for (TransformerJob transformerJob : this._analysisJob.getTransformerJobs()) {
            this.registerRowProcessingPublishers((ComponentJob)transformerJob);
        }
        for (AnalyzerJob analyzerJob : this._analysisJob.getAnalyzerJobs()) {
            this.registerRowProcessingPublishers((ComponentJob)analyzerJob);
        }
        for (RowProcessingPublisher publisher : this._rowProcessingPublishers.values()) {
            publisher.initialize();
        }
    }

    public Column[] getPhysicalColumns(ComponentJob componentJob) {
        InputColumn[] inputColumns;
        HashSet<Column> physicalColumns = new HashSet<Column>();
        for (InputColumn inputColumn : inputColumns = componentJob.getInput()) {
            physicalColumns.addAll(this._sourceColumnFinder.findOriginatingColumns(inputColumn));
        }
        ComponentRequirement requirement = componentJob.getComponentRequirement();
        if (requirement != null) {
            for (FilterOutcome filterOutcome : requirement.getProcessingDependencies()) {
                physicalColumns.addAll(this._sourceColumnFinder.findOriginatingColumns(filterOutcome));
            }
        }
        Column[] physicalColumnsArray = physicalColumns.toArray(new Column[physicalColumns.size()]);
        return physicalColumnsArray;
    }

    public Table[] getTables(ComponentJob componentJob) {
        return this.getTables(componentJob, null);
    }

    public Table[] getTables(ComponentJob componentJob, Column[] physicalColumns) {
        Table[] tables;
        if (physicalColumns == null) {
            physicalColumns = this.getPhysicalColumns(componentJob);
        }
        if (physicalColumns.length == 0) {
            HashSet<Table> allTables = new HashSet<Table>();
            List allSourceColumns = this._analysisJob.getSourceColumns();
            for (InputColumn inputColumn : allSourceColumns) {
                allTables.add(inputColumn.getPhysicalColumn().getTable());
            }
            tables = allTables.toArray(new Table[allTables.size()]);
        } else {
            tables = MetaModelHelper.getTables((Column[])physicalColumns);
        }
        if (tables.length > 1) {
            throw new IllegalStateException("Component has input columns from multiple tables: " + componentJob);
        }
        if (tables.length == 0) {
            throw new IllegalStateException("Component has no dependent tables: " + componentJob);
        }
        return tables;
    }

    private void registerRowProcessingPublishers(ComponentJob componentJob) {
        Table[] tables;
        Column[] physicalColumns = this.getPhysicalColumns(componentJob);
        for (Table table : tables = this.getTables(componentJob, physicalColumns)) {
            RowProcessingPublisher rowPublisher = this._rowProcessingPublishers.get(table);
            if (rowPublisher == null) {
                rowPublisher = new RowProcessingPublisher(this, table);
                rowPublisher.addPrimaryKeysIfSourced();
                this._rowProcessingPublishers.put(table, rowPublisher);
            }
            rowPublisher.addPhysicalColumns(physicalColumns);
            InputColumn<?>[] localInputColumns = this.getLocalInputColumns(table, componentJob.getInput());
            if (componentJob instanceof AnalyzerJob) {
                AnalyzerJob analyzerJob = (AnalyzerJob)componentJob;
                Analyzer analyzer = (Analyzer)analyzerJob.getDescriptor().newInstance();
                rowPublisher.addAnalyzerBean(analyzer, analyzerJob, localInputColumns);
                continue;
            }
            if (componentJob instanceof TransformerJob) {
                TransformerJob transformerJob = (TransformerJob)componentJob;
                Transformer transformer = (Transformer)transformerJob.getDescriptor().newInstance();
                rowPublisher.addTransformerBean(transformer, transformerJob, localInputColumns);
                continue;
            }
            if (componentJob instanceof FilterJob) {
                FilterJob filterJob = (FilterJob)componentJob;
                Filter filter = (Filter)filterJob.getDescriptor().newInstance();
                rowPublisher.addFilterBean(filter, filterJob, localInputColumns);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported component job type: " + componentJob);
        }
    }

    private InputColumn<?>[] getLocalInputColumns(Table table, InputColumn<?>[] inputColumns) {
        if (table == null || inputColumns == null || inputColumns.length == 0) {
            return new InputColumn[0];
        }
        ArrayList result = new ArrayList();
        block0: for (InputColumn<?> inputColumn : inputColumns) {
            Set<Column> sourcePhysicalColumns = this._sourceColumnFinder.findOriginatingColumns(inputColumn);
            for (Column physicalColumn : sourcePhysicalColumns) {
                if (!table.equals(physicalColumn.getTable())) continue;
                result.add(inputColumn);
                continue block0;
            }
        }
        return result.toArray(new InputColumn[result.size()]);
    }

    public int size() {
        return this._rowProcessingPublishers.size();
    }

    public RowProcessingPublisher getRowProcessingPublisher(Table table) {
        return this._rowProcessingPublishers.get(table);
    }

    public Collection<RowProcessingPublisher> getRowProcessingPublishers() {
        return this._rowProcessingPublishers.values();
    }

    public Table[] getTables() {
        Set<Table> tables = this._rowProcessingPublishers.keySet();
        return tables.toArray(new Table[tables.size()]);
    }

    public AnalysisJobMetrics getAnalysisJobMetrics() {
        return new AnalysisJobMetricsImpl(this._analysisJob, this);
    }

    public SourceColumnFinder getSourceColumnFinder() {
        return this._sourceColumnFinder;
    }

    protected AnalysisJob getAnalysisJob() {
        return this._analysisJob;
    }

    protected AnalysisListener getAnalysisListener() {
        return this._analysisListener;
    }

    protected LifeCycleHelper getLifeCycleHelper() {
        return this._lifeCycleHelper;
    }

    protected TaskRunner getTaskRunner() {
        return this._taskRunner;
    }

    public Datastore getDatastore() {
        return this._analysisJob.getDatastore();
    }
}

