/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.metamodel.query.Query;
import org.datacleaner.api.Filter;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.QueryOptimizedFilter;
import org.datacleaner.components.maxrows.MaxRowsFilter;
import org.datacleaner.connection.Datastore;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.HasComponentRequirement;
import org.datacleaner.job.HasFilterOutcomes;
import org.datacleaner.job.InputColumnSinkJob;
import org.datacleaner.job.InputColumnSourceJob;
import org.datacleaner.job.runner.FilterConsumer;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowProcessingQueryOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(RowProcessingQueryOptimizer.class);
    private static final Class<?>[] ALWAYS_OPTIMIZABLE = new Class[]{MaxRowsFilter.class};
    private final Datastore _datastore;
    private final Query _baseQuery;
    private final List<RowProcessingConsumer> _consumers;
    private final Map<FilterConsumer, FilterOutcome> _optimizedFilters;

    public RowProcessingQueryOptimizer(Datastore datastore, List<RowProcessingConsumer> consumers, Query baseQuery) {
        this._datastore = datastore;
        this._consumers = consumers;
        this._baseQuery = baseQuery;
        this._optimizedFilters = new HashMap<FilterConsumer, FilterOutcome>();
        this.init();
    }

    private void init() {
        int consumerIndex = 0;
        for (RowProcessingConsumer consumer : this._consumers) {
            if (consumer instanceof FilterConsumer) {
                FilterConsumer filterConsumer = (FilterConsumer)consumer;
                if (!this.isOptimizable(filterConsumer)) {
                    logger.debug("Breaking optimization. Not optimizable: {}", (Object)filterConsumer);
                    break;
                }
                Collection outcomes = filterConsumer.getComponentJob().getFilterOutcomes();
                FilterOutcome optimizableOutcome = null;
                for (FilterOutcome outcome : outcomes) {
                    boolean optimizable = this.isOptimizable(filterConsumer, outcome, consumerIndex);
                    if (!optimizable) continue;
                    if (optimizableOutcome != null) break;
                    optimizableOutcome = outcome;
                }
                if (optimizableOutcome == null) break;
                this._optimizedFilters.put(filterConsumer, optimizableOutcome);
            }
            ++consumerIndex;
        }
    }

    private boolean isOptimizable(FilterConsumer filterConsumer) {
        InputColumn<?>[] input;
        FilterDescriptor descriptor = filterConsumer.getComponentJob().getDescriptor();
        if (!descriptor.isQueryOptimizable()) {
            logger.debug("FilterBeanDescriptor not optimizable: {}", (Object)descriptor);
            return false;
        }
        for (InputColumn<?> inputColumn : input = filterConsumer.getRequiredInput()) {
            if (!inputColumn.isVirtualColumn()) continue;
            logger.debug("InputColumn is virtual: {}, so filter is not optimizable: {}", inputColumn, (Object)filterConsumer);
            return false;
        }
        return true;
    }

    private boolean isOptimizable(FilterConsumer filterConsumer, FilterOutcome filterOutcome, int consumerIndex) {
        Class filterClass;
        if (!filterConsumer.isQueryOptimizable(filterOutcome)) {
            return false;
        }
        if (!this._datastore.getPerformanceCharacteristics().isQueryOptimizationPreferred() && !ArrayUtils.contains((Object[])ALWAYS_OPTIMIZABLE, (Object)(filterClass = filterConsumer.getComponentJob().getDescriptor().getComponentClass()))) {
            logger.debug("Datastore performance characteristics indicate that query optimization will not improve performance for {}, stopping", (Object)filterConsumer);
            return false;
        }
        HashSet<Object> satisfiedColumns = new HashSet<Object>();
        HashSet<FilterOutcome> satisfiedRequirements = new HashSet<FilterOutcome>();
        satisfiedRequirements.add(filterOutcome);
        for (int i = consumerIndex + 1; i < this._consumers.size(); ++i) {
            ComponentRequirement componentRequirement;
            boolean independentComponent = true;
            RowProcessingConsumer nextConsumer = this._consumers.get(i);
            ComponentJob componentJob = nextConsumer.getComponentJob();
            if (componentJob instanceof HasComponentRequirement && (componentRequirement = componentJob.getComponentRequirement()) != null) {
                Collection requirements = componentRequirement.getProcessingDependencies();
                for (FilterOutcome requirement : requirements) {
                    if (!satisfiedRequirements.contains(requirement)) {
                        logger.debug("Requirement {} is not met using query optimization of {}", (Object)requirement, (Object)filterConsumer);
                        return false;
                    }
                    independentComponent = false;
                }
            }
            if (componentJob instanceof InputColumnSinkJob) {
                InputColumn[] requiredColumns = componentJob.getInput();
                for (InputColumn inputColumn : requiredColumns) {
                    if (!inputColumn.isVirtualColumn()) continue;
                    if (!satisfiedColumns.contains(inputColumn)) {
                        logger.debug("InputColumn {} is available at query time, and therefore not satisfied for query optimization of {}", (Object)inputColumn, (Object)filterConsumer);
                        return false;
                    }
                    independentComponent = false;
                }
            }
            if (independentComponent) {
                logger.debug("Component {} is completely independent. Position in chain is not determinable, so optimization cannot be done.", (Object)filterConsumer);
                return false;
            }
            if (componentJob instanceof HasFilterOutcomes) {
                Collection outcomes = ((HasFilterOutcomes)componentJob).getFilterOutcomes();
                for (FilterOutcome outcome : outcomes) {
                    satisfiedRequirements.add(outcome);
                }
            }
            if (!(componentJob instanceof InputColumnSourceJob)) continue;
            InputColumn[] output = ((InputColumnSourceJob)componentJob).getOutput();
            for (InputColumn inputColumn : output) {
                satisfiedColumns.add(inputColumn);
            }
        }
        return true;
    }

    public Query getOptimizedQuery() {
        Query q = this._baseQuery.clone();
        Set<Map.Entry<FilterConsumer, FilterOutcome>> entries = this._optimizedFilters.entrySet();
        for (Map.Entry<FilterConsumer, FilterOutcome> entry : entries) {
            Query newQuery;
            FilterConsumer consumer = entry.getKey();
            FilterOutcome outcome = entry.getValue();
            Filter<?> filter = consumer.getComponent();
            QueryOptimizedFilter queryOptimizedFilter = (QueryOptimizedFilter)filter;
            q = newQuery = queryOptimizedFilter.optimizeQuery(q, outcome.getCategory());
        }
        return q;
    }

    public List<RowProcessingConsumer> getOptimizedConsumers() {
        ArrayList<RowProcessingConsumer> result = new ArrayList<RowProcessingConsumer>(this._consumers);
        for (FilterConsumer filterConsumer : this._optimizedFilters.keySet()) {
            if (!filterConsumer.isRemoveableUponOptimization()) continue;
            result.remove(filterConsumer);
        }
        return result;
    }

    public Set<? extends RowProcessingConsumer> getEliminatedConsumers() {
        Set<FilterConsumer> consumers = this._optimizedFilters.keySet();
        return consumers;
    }

    public Collection<? extends FilterOutcome> getOptimizedAvailableOutcomes() {
        return this._optimizedFilters.values();
    }

    public boolean isOptimizable() {
        return !this._optimizedFilters.isEmpty();
    }
}

