/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.concurrent.atomic.AtomicInteger;
import org.datacleaner.job.runner.RowIdGenerator;

class SimpleRowIdGenerator
implements RowIdGenerator {
    private final AtomicInteger _physicalCounter;
    private final AtomicInteger _virtualCounter;

    public SimpleRowIdGenerator(int offset) {
        this._physicalCounter = new AtomicInteger(offset);
        this._virtualCounter = new AtomicInteger(Integer.MIN_VALUE + offset * 3);
    }

    public SimpleRowIdGenerator() {
        this(0);
    }

    @Override
    public int nextPhysicalRowId() {
        return this._physicalCounter.incrementAndGet();
    }

    @Override
    public int nextVirtualRowId() {
        return this._virtualCounter.incrementAndGet();
    }
}

