/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.tasks;

import java.util.concurrent.atomic.AtomicBoolean;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.tasks.Task;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseTaskListener
implements TaskListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LifeCycleHelper _lifeCycleHelper;
    private final ComponentDescriptor<?> _descriptor;
    private final Object _component;
    private final AtomicBoolean _success;
    private final TaskListener _nextTaskListener;

    public CloseTaskListener(LifeCycleHelper lifeCycleHelper, ComponentDescriptor<?> descriptor, Object component, AtomicBoolean success) {
        this(lifeCycleHelper, descriptor, component, success, null);
    }

    public CloseTaskListener(LifeCycleHelper lifeCycleHelper, ComponentDescriptor<?> descriptor, Object component, AtomicBoolean success, TaskListener nextTaskListener) {
        this._lifeCycleHelper = lifeCycleHelper;
        this._descriptor = descriptor;
        this._component = component;
        this._success = success;
        this._nextTaskListener = nextTaskListener;
    }

    private void cleanup() {
        this.logger.debug("execute()");
        this._lifeCycleHelper.close(this._descriptor, this._component, this._success.get());
    }

    @Override
    public void onBegin(Task task) {
        if (this._nextTaskListener != null) {
            this._nextTaskListener.onBegin(task);
        }
    }

    @Override
    public void onComplete(Task task) {
        this.cleanup();
        if (this._nextTaskListener != null) {
            this._nextTaskListener.onComplete(task);
        }
    }

    @Override
    public void onError(Task task, Throwable throwable) {
        this._success.set(false);
        this.cleanup();
        if (this._nextTaskListener != null) {
            this._nextTaskListener.onError(task, throwable);
        }
    }
}

