/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.tasks;

import java.util.Collection;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.HasAnalyzerResult;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.JobAndResult;
import org.datacleaner.job.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectResultsTask
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(CollectResultsTask.class);
    private final HasAnalyzerResult<?> _hasResult;
    private final Collection<JobAndResult> _results;
    private final AnalysisListener _analysisListener;
    private final AnalysisJob _job;
    private final ComponentJob _componentJob;

    public CollectResultsTask(HasAnalyzerResult<?> hasResult, AnalysisJob job, ComponentJob componentJob, Collection<JobAndResult> results, AnalysisListener analysisListener) {
        this._hasResult = hasResult;
        this._job = job;
        this._componentJob = componentJob;
        this._results = results;
        this._analysisListener = analysisListener;
    }

    @Override
    public void execute() throws Exception {
        logger.debug("execute()");
        AnalyzerResult result = this._hasResult.getResult();
        if (result == null) {
            throw new IllegalStateException("Analyzer result (from " + this._hasResult + ") was null");
        }
        if (!(this._hasResult instanceof Analyzer)) {
            throw new UnsupportedOperationException("Unsupported component type: " + this._hasResult);
        }
        this._analysisListener.analyzerSuccess(this._job, (AnalyzerJob)this._componentJob, result);
        this._results.add(new JobAndResult(this._componentJob, result));
    }
}

