/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.lifecycle;

import java.lang.reflect.Array;
import java.util.Set;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.job.runner.ReferenceDataActivationManager;
import org.datacleaner.lifecycle.LifeCycleCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AssignConfiguredCallback
implements LifeCycleCallback<Object, ComponentDescriptor<?>> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ComponentConfiguration _beanConfiguration;
    private final ReferenceDataActivationManager _referenceDataActivationManager;

    public AssignConfiguredCallback(ComponentConfiguration beanConfiguration, ReferenceDataActivationManager referenceDataActivationManager) {
        this._beanConfiguration = beanConfiguration;
        this._referenceDataActivationManager = referenceDataActivationManager;
    }

    @Override
    public void onEvent(Object component, ComponentDescriptor<?> descriptor) {
        Set configuredProperties = descriptor.getConfiguredProperties();
        for (ConfiguredPropertyDescriptor property : configuredProperties) {
            Object configuredValue = this.getValue(property);
            if (configuredValue == null) {
                this.setValue(property, component, null);
                continue;
            }
            if (property.isArray()) {
                this.setValue(property, component, configuredValue);
                continue;
            }
            if (configuredValue.getClass().isArray()) {
                if (Array.getLength(configuredValue) == 1) {
                    configuredValue = Array.get(configuredValue, 0);
                } else {
                    if (Array.getLength(configuredValue) > 1) {
                        throw new IllegalStateException("Cannot assign an array-value (" + configuredValue + ") to a non-array property (" + property + ")");
                    }
                    configuredValue = null;
                }
            }
            this.setValue(property, component, configuredValue);
        }
    }

    protected void setValue(ConfiguredPropertyDescriptor property, Object component, Object value) {
        if (this._referenceDataActivationManager != null && this._referenceDataActivationManager.accepts(value)) {
            this._referenceDataActivationManager.register(value);
        }
        property.setValue(component, value);
    }

    protected Object getValue(ConfiguredPropertyDescriptor propertyDescriptor) {
        this.logger.debug("Getting property from bean configuration");
        Object value = this._beanConfiguration.getProperty(propertyDescriptor);
        this.logger.debug("{} -> {}", (Object)propertyDescriptor.getName(), value);
        return value;
    }
}

