/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.lifecycle;

import java.util.Set;
import org.datacleaner.descriptors.CloseMethodDescriptor;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.lifecycle.LifeCycleCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CloseCallback
implements LifeCycleCallback<Object, ComponentDescriptor<?>> {
    private static final Logger logger = LoggerFactory.getLogger(CloseCallback.class);
    private final boolean _includeNonDistributed;
    private final boolean _success;

    public CloseCallback(boolean includeNonDistributed, boolean success) {
        this._includeNonDistributed = includeNonDistributed;
        this._success = success;
    }

    @Override
    public void onEvent(Object analyzerBean, ComponentDescriptor<?> descriptor) {
        Set closeMethods = descriptor.getCloseMethods();
        for (CloseMethodDescriptor closeDescriptor : closeMethods) {
            if (!this._includeNonDistributed && !closeDescriptor.isDistributed()) continue;
            if (this._success && closeDescriptor.isEnabledOnSuccess()) {
                closeDescriptor.close(analyzerBean);
                continue;
            }
            if (!this._success && closeDescriptor.isEnabledOnFailure()) {
                closeDescriptor.close(analyzerBean);
                continue;
            }
            logger.debug("Omitting close method {} since success={}", (Object)closeDescriptor, (Object)this._success);
        }
    }
}

