/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.lifecycle;

import java.util.Set;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.InitializeMethodDescriptor;
import org.datacleaner.descriptors.ValidateMethodDescriptor;
import org.datacleaner.lifecycle.LifeCycleCallback;

final class InitializeCallback
implements LifeCycleCallback<Object, ComponentDescriptor<?>> {
    private final boolean _validate;
    private final boolean _initialize;
    private final boolean _initializeNonDistributed;

    public InitializeCallback(boolean validate, boolean initialize, boolean initializeNonDistributed) {
        this._validate = validate;
        this._initialize = initialize;
        this._initializeNonDistributed = initializeNonDistributed;
    }

    @Override
    public void onEvent(Object component, ComponentDescriptor<?> descriptor) {
        if (this._validate) {
            Set validateDescriptors = descriptor.getValidateMethods();
            for (ValidateMethodDescriptor validateDescriptor : validateDescriptors) {
                validateDescriptor.validate(component);
            }
        }
        if (this._initialize) {
            Set initializeDescriptors = descriptor.getInitializeMethods();
            for (InitializeMethodDescriptor initializeDescriptor : initializeDescriptors) {
                if (!this._initializeNonDistributed && !initializeDescriptor.isDistributed()) continue;
                initializeDescriptor.initialize(component);
            }
        }
    }
}

