/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.lifecycle;

import java.util.Collection;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.Descriptors;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.job.runner.ReferenceDataActivationManager;
import org.datacleaner.lifecycle.AssignConfiguredCallback;
import org.datacleaner.lifecycle.AssignProvidedCallback;
import org.datacleaner.lifecycle.CloseCallback;
import org.datacleaner.lifecycle.InitializeCallback;

public final class LifeCycleHelper {
    private final InjectionManager _injectionManager;
    private final ReferenceDataActivationManager _referenceDataActivationManager;
    private boolean _includeNonDistributedTasks;

    @Deprecated
    public LifeCycleHelper(InjectionManager injectionManager) {
        this(injectionManager, null, true);
    }

    @Deprecated
    public LifeCycleHelper(InjectionManager injectionManager, ReferenceDataActivationManager referenceDataActivationManager) {
        this(injectionManager, referenceDataActivationManager, true);
    }

    public LifeCycleHelper(InjectionManager injectionManager, boolean includeNonDistributedTasks) {
        this(injectionManager, null, includeNonDistributedTasks);
    }

    public LifeCycleHelper(InjectionManager injectionManager, ReferenceDataActivationManager referenceDataActivationManager, boolean includeNonDistributedTasks) {
        this._injectionManager = injectionManager;
        this._referenceDataActivationManager = referenceDataActivationManager;
        this._includeNonDistributedTasks = includeNonDistributedTasks;
    }

    public boolean isIncludeNonDistributedTasks() {
        return this._includeNonDistributedTasks;
    }

    public InjectionManager getInjectionManager() {
        return this._injectionManager;
    }

    public ReferenceDataActivationManager getReferenceDataActivationManager() {
        return this._referenceDataActivationManager;
    }

    public void assignConfiguredProperties(ComponentDescriptor<?> descriptor, Object component, ComponentConfiguration beanConfiguration) {
        AssignConfiguredCallback callback = new AssignConfiguredCallback(beanConfiguration, this._referenceDataActivationManager);
        callback.onEvent(component, descriptor);
    }

    public void assignProvidedProperties(ComponentDescriptor<?> descriptor, Object component) {
        AssignProvidedCallback callback = new AssignProvidedCallback(this._injectionManager);
        callback.onEvent(component, descriptor);
    }

    public void validate(ComponentDescriptor<?> descriptor, Object component) {
        InitializeCallback callback = new InitializeCallback(true, false, this._includeNonDistributedTasks);
        callback.onEvent(component, descriptor);
    }

    public void initialize(ComponentDescriptor<?> descriptor, Object component) {
        InitializeCallback callback = new InitializeCallback(true, true, this._includeNonDistributedTasks);
        callback.onEvent(component, descriptor);
    }

    public void close(ComponentDescriptor<?> descriptor, Object component, boolean success) {
        CloseCallback callback = new CloseCallback(this._includeNonDistributedTasks, success);
        callback.onEvent(component, descriptor);
    }

    @Deprecated
    public void close(ComponentDescriptor<?> descriptor, Object component) {
        this.close(descriptor, component, true);
    }

    public void closeReferenceData() {
        if (this._referenceDataActivationManager == null) {
            return;
        }
        Collection<Object> referenceData = this._referenceDataActivationManager.getAllReferenceData();
        for (Object object : referenceData) {
            ComponentDescriptor<?> descriptor = Descriptors.ofComponent(object.getClass());
            this.close(descriptor, object, true);
        }
    }

    public void initializeReferenceData() {
        if (this._referenceDataActivationManager == null) {
            return;
        }
        Collection<Object> referenceDataCollection = this._referenceDataActivationManager.getAllReferenceData();
        for (Object referenceData : referenceDataCollection) {
            ComponentDescriptor<?> descriptor = Descriptors.ofComponent(referenceData.getClass());
            this.assignProvidedProperties(descriptor, referenceData);
            this.initialize(descriptor, referenceData);
        }
    }
}

