/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metadata;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.metamodel.util.HasName;
import org.datacleaner.metadata.HasMetadataAnnotations;
import org.datacleaner.metadata.MetadataAnnotation;
import org.datacleaner.metadata.MetadataAnnotationAdaptor;

abstract class AbstractHasMetadataAnnotations
implements HasMetadataAnnotations {
    private final ImmutableList<MetadataAnnotation> _annotations;

    public AbstractHasMetadataAnnotations(Collection<? extends MetadataAnnotation> annotations) {
        this._annotations = ImmutableList.copyOf(annotations);
    }

    public MetadataAnnotation getAnnotation(String annotationName) {
        if (Strings.isNullOrEmpty((String)annotationName)) {
            return null;
        }
        for (MetadataAnnotation annotation : this._annotations) {
            if (!annotationName.equals(annotation.getName())) continue;
            return annotation;
        }
        for (MetadataAnnotation annotation : this._annotations) {
            if (!annotationName.equalsIgnoreCase(annotation.getName())) continue;
            return annotation;
        }
        return null;
    }

    public <M> M getAdaptedAnnotation(MetadataAnnotationAdaptor<M> annotationAdaptor) {
        if (annotationAdaptor == null) {
            return null;
        }
        String annotationName = annotationAdaptor.getAnnotationName();
        MetadataAnnotation annotation = this.getAnnotation(annotationName);
        if (annotation == null) {
            return null;
        }
        Object result = annotationAdaptor.convertFromAnnotation(annotation);
        return (M)result;
    }

    public List<MetadataAnnotation> getAnnotations() {
        return this._annotations;
    }

    protected <H extends HasName> H getByName(String name, Collection<? extends H> hasNames) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        for (HasName hasName : hasNames) {
            if (!name.equals(hasName.getName())) continue;
            return (H)hasName;
        }
        for (HasName hasName : hasNames) {
            if (!name.equalsIgnoreCase(hasName.getName())) continue;
            return (H)hasName;
        }
        return null;
    }
}

