/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.metadata;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.metamodel.schema.Table;
import org.datacleaner.metadata.AbstractHasMetadataAnnotations;
import org.datacleaner.metadata.MetadataAnnotation;
import org.datacleaner.metadata.SchemaMetadata;
import org.datacleaner.metadata.TableMetadata;

public final class SchemaMetadataImpl
extends AbstractHasMetadataAnnotations
implements SchemaMetadata {
    private final ImmutableList<TableMetadata> _tableMetadata;
    private final String _schemaName;

    public SchemaMetadataImpl(String schemaName, Collection<? extends TableMetadata> tableMetadata, Collection<? extends MetadataAnnotation> annotations) {
        super(annotations);
        this._schemaName = schemaName;
        this._tableMetadata = ImmutableList.copyOf(tableMetadata);
    }

    public String getName() {
        return this._schemaName;
    }

    public TableMetadata getTableMetadataByName(String tableName) {
        return this.getByName(tableName, this._tableMetadata);
    }

    public TableMetadata getTableMetadata(Table table) {
        if (table == null) {
            return null;
        }
        String tableName = table.getName();
        return this.getTableMetadataByName(tableName);
    }

    public List<TableMetadata> getTableMetadata() {
        return this._tableMetadata;
    }
}

