/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.output.csv;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvDataContext;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.InputColumn;
import org.datacleaner.output.OutputWriter;
import org.datacleaner.output.csv.CsvOutputWriter;

public final class CsvOutputWriterFactory {
    private static final Map<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();
    private static final Map<String, UpdateableDataContext> dataContexts = new HashMap<String, UpdateableDataContext>();

    public static OutputWriter getWriter(String filename, List<InputColumn<?>> columns) {
        InputColumn[] columnArray = columns.toArray(new InputColumn[columns.size()]);
        String[] headers = new String[columnArray.length];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = columnArray[i].getName();
        }
        return CsvOutputWriterFactory.getWriter(filename, headers, Character.valueOf(','), Character.valueOf('\"'), Character.valueOf('\\'), true, columnArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputWriter getWriter(String filename, final String[] headers, Character separatorChar, Character quoteChar, Character escapeChar, boolean includeHeader, InputColumn<?> ... columns) {
        CsvOutputWriter outputWriter;
        Map<String, UpdateableDataContext> map = dataContexts;
        synchronized (map) {
            UpdateableDataContext dataContext = dataContexts.get(filename);
            if (dataContext == null) {
                File file = new File(filename);
                File parentFile = file.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                dataContext = new CsvDataContext(file, CsvOutputWriterFactory.getConfiguration(separatorChar, quoteChar, escapeChar, includeHeader));
                final Schema schema = dataContext.getDefaultSchema();
                dataContext.executeUpdate(new UpdateScript(){

                    public void run(UpdateCallback callback) {
                        TableCreationBuilder tableBuilder = callback.createTable(schema, "table");
                        for (String header : headers) {
                            tableBuilder.withColumn(header);
                        }
                        tableBuilder.execute();
                    }
                });
                Table table = dataContext.getDefaultSchema().getTables()[0];
                dataContexts.put(filename, dataContext);
                counters.put(filename, new AtomicInteger(1));
                outputWriter = new CsvOutputWriter(dataContext, filename, table, columns);
            } else {
                Table table = dataContext.getDefaultSchema().getTables()[0];
                outputWriter = new CsvOutputWriter(dataContext, filename, table, columns);
                counters.get(filename).incrementAndGet();
            }
        }
        return outputWriter;
    }

    private static CsvConfiguration getConfiguration(Character separatorChar, Character quoteChar, Character escapeChar, boolean includeHeader) {
        if (separatorChar == null) {
            separatorChar = Character.valueOf('\uffff');
        }
        if (quoteChar == null) {
            quoteChar = Character.valueOf('\uffff');
        }
        if (escapeChar == null) {
            escapeChar = Character.valueOf('\uffff');
        }
        int headerLine = includeHeader ? 1 : 0;
        return new CsvConfiguration(headerLine, "UTF-8", separatorChar.charValue(), quoteChar.charValue(), escapeChar.charValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void release(String filename) {
        int count = counters.get(filename).decrementAndGet();
        if (count == 0) {
            Map<String, UpdateableDataContext> map = dataContexts;
            synchronized (map) {
                dataContexts.remove(filename);
            }
        }
    }
}

