/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.output.excel;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.excel.ExcelDataContext;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.MutableRef;
import org.datacleaner.api.InputColumn;
import org.datacleaner.output.OutputWriter;
import org.datacleaner.output.excel.ExcelOutputWriter;

public final class ExcelOutputWriterFactory {
    private static final Map<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();
    private static final Map<String, UpdateableDataContext> dataContexts = new HashMap<String, UpdateableDataContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputWriter getWriter(String filename, String sheetName, InputColumn<?> ... columns) {
        ExcelOutputWriter outputWriter;
        Map<String, UpdateableDataContext> map = dataContexts;
        synchronized (map) {
            UpdateableDataContext dataContext = dataContexts.get(filename);
            if (dataContext == null) {
                File file = new File(filename);
                dataContext = new ExcelDataContext(file);
                Table table = ExcelOutputWriterFactory.getTable(dataContext, sheetName, columns);
                dataContexts.put(filename, dataContext);
                counters.put(filename, new AtomicInteger(1));
                outputWriter = new ExcelOutputWriter(dataContext, filename, table, columns);
            } else {
                Table table = ExcelOutputWriterFactory.getTable(dataContext, sheetName, columns);
                outputWriter = new ExcelOutputWriter(dataContext, filename, table, columns);
                counters.get(filename).incrementAndGet();
            }
        }
        return outputWriter;
    }

    private static Table getTable(UpdateableDataContext dataContext, final String sheetName, final InputColumn<?>[] columns) {
        final Schema schema = dataContext.getDefaultSchema();
        Table table = schema.getTableByName(sheetName);
        if (table == null) {
            final MutableRef tableRef = new MutableRef();
            dataContext.executeUpdate(new UpdateScript(){

                public void run(UpdateCallback callback) {
                    TableCreationBuilder tableBuilder = callback.createTable(schema, sheetName);
                    for (InputColumn inputColumn : columns) {
                        tableBuilder.withColumn(inputColumn.getName());
                    }
                    tableRef.set((Object)tableBuilder.execute());
                }
            });
            table = (Table)tableRef.get();
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void release(String filename) {
        int count = counters.get(filename).decrementAndGet();
        if (count == 0) {
            Map<String, UpdateableDataContext> map = dataContexts;
            synchronized (map) {
                dataContexts.remove(filename);
            }
        }
    }
}

