/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import org.apache.metamodel.schema.Column;
import org.datacleaner.api.Close;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.Provided;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreCatalog;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.SchemaNavigator;
import org.datacleaner.reference.AbstractReferenceData;
import org.datacleaner.reference.DatastoreReferenceValues;
import org.datacleaner.reference.Dictionary;
import org.datacleaner.reference.ReferenceValues;
import org.datacleaner.util.ReadObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatastoreDictionary
extends AbstractReferenceData
implements Dictionary {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DatastoreDictionary.class);
    private transient ReferenceValues<String> _cachedRefValues;
    private transient BlockingQueue<DatastoreConnection> _datastoreConnections = new LinkedBlockingQueue<DatastoreConnection>();
    private final String _datastoreName;
    private final String _qualifiedColumnName;
    @Inject
    @Provided
    transient DatastoreCatalog _datastoreCatalog;

    public DatastoreDictionary(String name, String datastoreName, String qualifiedColumnName) {
        super(name);
        this._datastoreName = datastoreName;
        this._qualifiedColumnName = qualifiedColumnName;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, DatastoreDictionary.class).readObject(stream);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._datastoreName);
        identifiers.add(this._qualifiedColumnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingQueue<DatastoreConnection> getDatastoreConnections() {
        if (this._datastoreConnections == null) {
            DatastoreDictionary datastoreDictionary = this;
            synchronized (datastoreDictionary) {
                if (this._datastoreConnections == null) {
                    this._datastoreConnections = new LinkedBlockingQueue<DatastoreConnection>();
                }
            }
        }
        return this._datastoreConnections;
    }

    @Initialize
    public void init() {
        logger.info("Initializing dictionary: {}", (Object)this);
        Datastore datastore = this.getDatastore();
        DatastoreConnection con = datastore.openConnection();
        this.getDatastoreConnections().add(con);
    }

    @Close
    public void close() {
        DatastoreConnection con = (DatastoreConnection)this.getDatastoreConnections().poll();
        if (con != null) {
            logger.info("Closing dictionary: {}", (Object)this);
            con.close();
        }
    }

    private Datastore getDatastore() {
        Datastore datastore = this._datastoreCatalog.getDatastore(this._datastoreName);
        if (datastore == null) {
            throw new IllegalStateException("Could not resolve datastore " + this._datastoreName);
        }
        return datastore;
    }

    public DatastoreCatalog getDatastoreCatalog() {
        return this._datastoreCatalog;
    }

    public String getDatastoreName() {
        return this._datastoreName;
    }

    public String getQualifiedColumnName() {
        return this._qualifiedColumnName;
    }

    @Override
    public boolean containsValue(String value) {
        return this.getValues().containsValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceValues<String> getValues() {
        if (this._cachedRefValues == null) {
            DatastoreDictionary datastoreDictionary = this;
            synchronized (datastoreDictionary) {
                if (this._cachedRefValues == null) {
                    Datastore datastore = this.getDatastore();
                    DatastoreConnection datastoreConnection = datastore.openConnection();
                    SchemaNavigator schemaNavigator = datastoreConnection.getSchemaNavigator();
                    Column column = schemaNavigator.convertToColumns(new String[]{this._qualifiedColumnName})[0];
                    if (column == null) {
                        throw new IllegalStateException("Could not resolve column " + this._qualifiedColumnName);
                    }
                    this._cachedRefValues = new DatastoreReferenceValues(datastore, column);
                    datastoreConnection.close();
                }
            }
        }
        return this._cachedRefValues;
    }
}

